/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.lang;

public class ByteArray {
    private byte[] myBits;

    public ByteArray(byte[] b) {
        this.myBits = b;
    }

    public static String byteArrayToString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int sz = b.length;
        for (int i = 0; i < sz; ++i) {
            ret.append(ByteArray.byteToString(b[i]));
        }
        return ret.toString();
    }

    public static String byteToString(byte b) {
        String tmp;
        int i = b;
        if (i < 0) {
            i += 256;
        }
        if ((tmp = Integer.toHexString(i)).length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    public static byte stringToByte(String s) {
        try {
            return (byte)Integer.parseInt(s, 16);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public static byte[] stringToByteArray(String bstr) {
        if (bstr == null) {
            return null;
        }
        int sz = bstr.length();
        byte[] bytes = new byte[sz / 2];
        for (int i = 0; i < sz / 2; ++i) {
            bytes[i] = ByteArray.stringToByte(bstr.substring(2 * i, 2 * i + 2));
        }
        return bytes;
    }

    public static byte[] longArrayToByteArray(long[] lns) {
        byte[] ret = new byte[lns.length * 8];
        for (int i = 0; i < lns.length; ++i) {
            ret[i * 8 + 0] = (byte)(lns[i] >> 0 & 0xFFL);
            ret[i * 8 + 1] = (byte)(lns[i] >> 8 & 0xFFL);
            ret[i * 8 + 2] = (byte)(lns[i] >> 16 & 0xFFL);
            ret[i * 8 + 3] = (byte)(lns[i] >> 24 & 0xFFL);
            ret[i * 8 + 4] = (byte)(lns[i] >> 32 & 0xFFL);
            ret[i * 8 + 5] = (byte)(lns[i] >> 40 & 0xFFL);
            ret[i * 8 + 6] = (byte)(lns[i] >> 48 & 0xFFL);
            ret[i * 8 + 7] = (byte)(lns[i] >> 56 & 0xFFL);
        }
        return ret;
    }
}

