/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class JdbcW {
    static Object[] resultSetToArray(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int sz = meta.getColumnCount();
        Object[] objs = new Object[sz];
        for (int i = 0; i < sz; ++i) {
            Object obj = rs.getObject(i + 1);
            if (rs.wasNull()) {
                obj = null;
            }
            objs[i] = obj;
        }
        return objs;
    }

    public static String[] getColumnNames(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int sz = rsmd.getColumnCount();
        String[] names = new String[sz];
        for (int i = 0; i < sz; ++i) {
            names[i] = rsmd.getColumnName(i + 1);
        }
        return names;
    }

    public static int getColumnType(String column, Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = null;
        String schema = null;
        String table = null;
        String columnName = null;
        String[] args = StringUtils.split((String)column, (String)".");
        if (args.length == 4) {
            catalog = args[0];
            schema = args[1];
            table = args[2];
            columnName = args[3];
        } else if (args.length == 3) {
            schema = args[0];
            table = args[1];
            columnName = args[2];
        } else {
            table = args[0];
            columnName = args[1];
        }
        ResultSet rs = meta.getColumns(catalog, schema, table, columnName);
        if (rs.next()) {
            return rs.getInt(5);
        }
        return -1;
    }

    public static String[] getPrimaryKeys(String tablename, Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = null;
        String schema = null;
        String table = null;
        String[] args = StringUtils.split((String)tablename, (String)".");
        if (args.length == 3) {
            catalog = args[0];
            schema = args[1];
            table = args[2];
        } else if (args.length == 2) {
            schema = args[0];
            table = args[1];
        } else {
            table = args[0];
        }
        ResultSet rs = meta.getPrimaryKeys(catalog, schema, table);
        ArrayList<Object> list = new ArrayList<Object>();
        while (rs.next()) {
            rs.getObject(1);
            rs.getObject(2);
            rs.getObject(3);
            list.add(rs.getObject(4));
        }
        return list.toArray(new String[0]);
    }

    public static Object getAutoIncrement(String tablename, Connection conn, String pkey) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getPrimaryKeys(null, null, tablename);
        while (rs.next()) {
            rs.getObject(1);
            rs.getObject(2);
            rs.getObject(3);
            String pk = rs.getString(4);
            if (!pkey.equals(pk)) continue;
            return rs.getObject(5);
        }
        return null;
    }

    public static Map getAutoIncrements(String tablename, Connection conn) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getPrimaryKeys(null, null, tablename);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            while (rs.next()) {
                map.put(rs.getObject(4), rs.getObject(5));
            }
            return map;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            return null;
        }
    }

    public static void printWarnings(SQLWarning warning) {
        if (warning == null) {
            return;
        }
        System.err.println(JdbcW.formatWarnings(warning));
    }

    public static String formatWarnings(SQLWarning warning) {
        StringBuffer buffer = new StringBuffer();
        while (warning != null) {
            buffer.append("SQLWarning: ");
            buffer.append(warning.getMessage());
            buffer.append("\nSQL State: ");
            buffer.append(warning.getSQLState());
            buffer.append("\nErrorCode: ");
            buffer.append(warning.getErrorCode());
            buffer.append("\n");
            warning = warning.getNextWarning();
        }
        return buffer.toString();
    }
}

