/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.io;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedList;

public final class FileW {
    public static String loadFile(String filename) {
        File file = new File(filename);
        return FileW.loadFile(file);
    }

    public static String loadFile(InputStream in) {
        try {
            int ptr = 0;
            StringBuffer buffer = new StringBuffer();
            while ((ptr = in.read()) != -1) {
                buffer.append((char)ptr);
            }
            return buffer.toString();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static String loadFile(URL url) {
        try {
            InputStream in = url.openStream();
            String str = FileW.loadFile(in);
            in.close();
            return str;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static String loadFile(File file) {
        try {
            FileReader rdr = new FileReader(file);
            long sz = file.length();
            char[] ch = new char[(int)sz];
            rdr.read(ch);
            ((Reader)rdr).close();
            return new String(ch);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static String loadFromClasspath(String file) {
        return FileW.loadFromClasspath(file, ClassLoader.getSystemClassLoader());
    }

    public static String loadFromClasspath(String file, Object instance) {
        return FileW.loadFromClasspath(file, instance.getClass().getClassLoader());
    }

    public static String loadFromClasspath(String file, ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        URL url = loader.getResource(file);
        if (url == null) {
            url = loader.getResource("/" + file);
        }
        if (url == null) {
            return null;
        }
        return FileW.loadFile(url);
    }

    public static boolean saveFile(String filename, String contents) {
        try {
            File file = new File(filename);
            if (file.getParent() != null) {
                new File(file.getParent()).mkdirs();
            }
            FileWriter wtr = new FileWriter(file);
            char[] ch = contents.toCharArray();
            wtr.write(ch);
            ((Writer)wtr).close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static String getClassName(File file) {
        String path = file.getPath();
        path = FileW.removePwd(path);
        return FileW.dottify(FileW.removeExtension(path));
    }

    public static String removePwd(String in) {
        if (in == null) {
            return null;
        }
        String pwd = System.getProperty("user.dir");
        if (pwd.length() == in.length()) {
            return in;
        }
        int idx = in.indexOf(pwd);
        if (idx == 0) {
            in = in.substring(pwd.length() + 1);
        }
        return in;
    }

    public static String removeExtension(String in) {
        if (in == null) {
            return null;
        }
        int idx = in.lastIndexOf(File.separator);
        int dot = in.indexOf(".");
        if (dot != -1 && dot > idx) {
            in = in.substring(0, dot);
        }
        return in;
    }

    public static String dottify(String in) {
        if (in == null) {
            return null;
        }
        int idx = in.indexOf(File.separator);
        while (idx != -1) {
            if (in.length() == 1) {
                return "";
            }
            in = idx == 0 ? in.substring(1) : (idx == in.length() ? in.substring(0, in.length() - 1) : in.substring(0, idx) + "." + in.substring(idx + 1));
            idx = in.indexOf("/");
        }
        return in;
    }

    public static File[] findFiles(String str) {
        return FileW.findFiles(str, new File(System.getProperty("user.home")));
    }

    public static File[] findFiles(String str, File directory) {
        LinkedList<File> files = new LinkedList<File>();
        files.add(new File(directory, str));
        return files.toArray(new File[0]);
    }
}

