/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.io;

import com.generationjava.io.FileEvent;
import com.generationjava.io.PollListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;

public class FilePoller
implements Runnable {
    private File file;
    private long delay;
    private StringBuffer buffer;
    private LinkedList listeners;

    public static void main(String[] strs) {
        FilePoller.pollFile(strs[0]);
    }

    public static void pollFile(String filename) {
        File file = new File(filename);
        FilePoller fp = new FilePoller();
        fp.addListener(new PollListener(){

            public void fileChanged(FileEvent fe) {
                System.err.println("File changed. ");
            }
        });
        fp.setFile(file);
        fp.setDelay(1L);
        Thread t = new Thread(fp);
        t.start();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void addListener(PollListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        if (this.listeners == null) {
            return;
        }
        FileEvent fe = new FileEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PollListener pl = (PollListener)iterator.next();
            pl.fileChanged(fe);
        }
    }

    public void run() {
        long length = this.file.length();
        long lastMod = this.file.lastModified();
        while (true) {
            if (length != this.file.length() || lastMod != this.file.lastModified()) {
                this.notifyListeners();
            }
            length = this.file.length();
            lastMod = this.file.lastModified();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    private void append(char ch) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.append(ch);
    }

    public String getData() {
        return this.buffer.toString();
    }

    public void clearData() {
        this.buffer = null;
    }
}

