/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.collections;

import com.generationjava.collections.LimitedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class SortedLimitedList
extends LimitedList {
    private Comparator comparator;

    public SortedLimitedList(int capacity, Comparator comparator) {
        this(new ArrayList(), capacity, comparator);
    }

    public SortedLimitedList(List list, int capacity, Comparator comparator) {
        super(list, capacity);
        this.comparator = comparator;
    }

    public boolean add(Object obj) {
        if (this.isEmpty()) {
            return super.add(obj);
        }
        if (this.isFull() && this.comparator.compare(obj, this.get(this.size() - 1)) <= 0) {
            return false;
        }
        this.insertIntoSort(obj);
        return true;
    }

    private void insertIntoSort(Object obj) {
        int i;
        int sz = this.size();
        for (i = sz - 1; i > -1 && this.comparator.compare(obj, this.get(i)) > 0; --i) {
        }
        super.add(i + 1, obj);
    }

    public boolean addAll(Collection coll) {
        return super.addAll(coll);
    }

    public boolean addAll(int i, Collection coll) {
        return super.addAll(i, coll);
    }

    public boolean retainAll(Collection coll) {
        return super.retainAll(coll);
    }

    public void add(int i, Object obj) {
        super.add(i, obj);
    }

    public String toString() {
        return super.toString();
    }
}

