/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.collections;

import com.generationjava.collections.SortComparator;
import com.generationjava.collections.SortIndex;
import com.generationjava.compare.ObjectComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class SortedIterator
implements Iterator {
    private ArrayList cache = new ArrayList();
    private Iterator iterator;
    private boolean started;

    public SortedIterator(Iterator iterator) {
        int idx = 0;
        while (iterator.hasNext()) {
            this.cache.add(new SortIndex(idx, iterator.next()));
            ++idx;
        }
        if (this.iterator == null) {
            this.iterator = this.cache.iterator();
        }
    }

    public Object next() {
        this.started = true;
        return ((SortIndex)this.iterator.next()).getIndexed();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException("Unable to remove once it is sorted. ");
    }

    public void sort(Comparator cmp) {
        if (this.started) {
            throw new RuntimeException("Cannot sort as this iterator has been read from. ");
        }
        SortComparator srtr = new SortComparator(cmp);
        Collections.sort(this.cache, srtr);
        if (this.iterator == null) {
            this.iterator = this.cache.iterator();
        }
    }

    public void sort() {
        this.sort(new ObjectComparator());
    }
}

