/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.collections;

import com.generationjava.collections.CollectionsW;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class MultiKeyedMap
implements Map {
    private Map myMap = null;

    public MultiKeyedMap(Map m) {
        this.myMap = m;
    }

    public MultiKeyedMap() {
        this(new HashMap());
    }

    public void clear() {
        this.myMap.clear();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.containsValue(this.myMap, value);
    }

    private boolean containsValue(Map map, Object value) {
        Iterator values = map.values().iterator();
        while (values.hasNext()) {
            Object obj = values.next();
            if (obj instanceof Map && this.containsValue((Map)obj, value)) {
                return true;
            }
            if (value == obj) {
                return true;
            }
            if (!value.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return this.myMap.entrySet();
    }

    public boolean equals(Object o) {
        return ((Object)this.myMap).equals(o);
    }

    public Object get(Object key) {
        if (key instanceof Object[]) {
            Object[] keys = (Object[])key;
            Map map = this.myMap;
            int szLessOne = keys.length - 1;
            for (int i = 0; i < szLessOne; ++i) {
                Object value = map.get(keys[i]);
                if (!(value instanceof Map)) {
                    return null;
                }
                map = (Map)value;
            }
            return map.get(keys[szLessOne]);
        }
        return this.myMap.get(key);
    }

    public int hashCode() {
        return ((Object)this.myMap).hashCode();
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public Set keySet() {
        HashSet set = new HashSet();
        this.keySetRecurse(this.myMap, set, new LinkedList());
        return set;
    }

    private void keySetRecurse(Map map, Set set, LinkedList head) {
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            head.add(key);
            Object value = map.get(key);
            if (value instanceof Map) {
                this.keySetRecurse((Map)value, set, head);
            } else {
                set.add(head.toArray());
            }
            head.removeLast();
        }
    }

    public Object put(Object key, Object value) {
        if (key instanceof Object[]) {
            Object[] keys = (Object[])key;
            int szLessOne = keys.length - 1;
            Map map = this.myMap;
            for (int i = 0; i < szLessOne; ++i) {
                Object obj = map.get(keys[i]);
                if (obj instanceof Map) {
                    map = (Map)obj;
                    continue;
                }
                Map oldmap = map;
                map = CollectionsW.cloneNewEmptyMap(map);
                oldmap.put(keys[i], map);
            }
            return map.put(keys[szLessOne], value);
        }
        return this.myMap.put(key, value);
    }

    public void putAll(Map t) {
        Set set;
        if (t != null && (set = t.keySet()) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.put(key, t.get(key));
            }
        }
    }

    public Object remove(Object key) {
        if (key instanceof Object[]) {
            Object[] keys = (Object[])key;
            int szLessOne = keys.length - 1;
            Map map = this.myMap;
            for (int i = 0; i < szLessOne; ++i) {
                Object obj = map.get(keys[i]);
                if (!(obj instanceof Map)) {
                    return null;
                }
                map = (Map)obj;
            }
            return map.remove(keys[szLessOne]);
        }
        return this.myMap.remove(key);
    }

    public int size() {
        return this.values().size();
    }

    public Collection values() {
        LinkedList list = new LinkedList();
        this.valuesRecurse(this.myMap, list);
        return list;
    }

    private void valuesRecurse(Map map, Collection list) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = map.get(key);
            if (value instanceof Map) {
                this.valuesRecurse((Map)value, list);
                continue;
            }
            list.add(value);
        }
    }

    public String toString() {
        return this.myMap.toString();
    }
}

