/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.collections;

import com.generationjava.collections.ProxyList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LimitedList
extends ProxyList {
    private int capacity;

    public LimitedList(int capacity) {
        this(new ArrayList(), capacity);
    }

    public LimitedList(List list, int capacity) {
        super(list);
        this.capacity = capacity;
    }

    public boolean isFull() {
        return this.capacity == this.size();
    }

    public boolean add(Object obj) {
        if (this.isFull()) {
            return false;
        }
        return super.add(obj);
    }

    public boolean addAll(Collection coll) {
        if (this.capacity <= this.size() + coll.size()) {
            return false;
        }
        return super.addAll(coll);
    }

    public boolean addAll(int i, Collection coll) {
        if (this.capacity <= this.size() + coll.size()) {
            return false;
        }
        return super.addAll(i, coll);
    }

    public boolean retainAll(Collection coll) {
        return super.retainAll(coll);
    }

    public void add(int i, Object obj) {
        if (this.capacity == i) {
            return;
        }
        if (this.isFull()) {
            super.remove(this.capacity - 1);
            super.add(i, obj);
        } else {
            super.add(i, obj);
        }
    }

    public String toString() {
        return super.toString();
    }
}

