/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.collections;

import com.generationjava.collections.Grouper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.collections.IteratorUtils;

public class EnumerationGrouper
implements Grouper {
    private static Enumeration nullEnum = IteratorUtils.asEnumeration((Iterator)IteratorUtils.EMPTY_ITERATOR);
    private Hashtable table = new Hashtable();

    public EnumerationGrouper(Enumeration enumeration) {
        this.addEnumeration(enumeration);
    }

    public void addEnumeration(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            String classname = obj.getClass().getName();
            Object vec = this.table.get(classname);
            if (vec == null) {
                vec = new Vector();
                this.table.put(classname, vec);
            }
            ((Vector)vec).addElement(obj);
        }
    }

    public Enumeration enumerateGroup(String classname) {
        Object vec = this.table.get(classname);
        if (vec instanceof Vector) {
            return ((Vector)vec).elements();
        }
        return nullEnum;
    }

    public Enumeration enumerateTypes() {
        return this.table.keys();
    }
}

