/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ResourceCreationPoint;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class Stream
extends ResourceCreationPoint {
    private String streamBase;
    private boolean isUninteresting;
    private boolean isOpenOnCreation;
    private InstructionHandle ctorHandle;
    private boolean ignoreImplicitExceptions;
    private String bugType;

    public Stream(Location location, String streamClass, String streamBase) {
        super(location, streamClass);
        this.streamBase = streamBase;
        this.isUninteresting = true;
    }

    public Stream setInteresting(String bugType) {
        this.isUninteresting = false;
        this.bugType = bugType;
        return this;
    }

    public Stream setIgnoreImplicitExceptions(boolean enable) {
        this.ignoreImplicitExceptions = enable;
        return this;
    }

    public Stream setIsOpenOnCreation(boolean enable) {
        this.isOpenOnCreation = enable;
        return this;
    }

    public String getStreamBase() {
        return this.streamBase;
    }

    public boolean isUninteresting() {
        return this.isUninteresting;
    }

    public boolean isOpenOnCreation() {
        return this.isOpenOnCreation;
    }

    public void setConstructorHandle(InstructionHandle handle) {
        this.ctorHandle = handle;
    }

    public InstructionHandle getConstructorHandle() {
        return this.ctorHandle;
    }

    public boolean ignoreImplicitExceptions() {
        return this.ignoreImplicitExceptions;
    }

    public String getBugType() {
        return this.bugType;
    }

    public boolean isStreamOpen(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, ResourceValueFrame frame) {
        if (this.isOpenOnCreation) {
            return false;
        }
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof INVOKESPECIAL)) {
            return false;
        }
        INVOKESPECIAL inv = (INVOKESPECIAL)ins;
        return frame.isValid() && this.getInstanceValue(frame, (InvokeInstruction)inv, cpg).isInstance() && this.matchMethod((InvokeInstruction)inv, cpg, this.getResourceClass(), "<init>");
    }

    public boolean isStreamClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, ResourceValueFrame frame, RepositoryLookupFailureCallback lookupFailureCallback) {
        Instruction ins = handle.getInstruction();
        if (ins instanceof INVOKEVIRTUAL || ins instanceof INVOKEINTERFACE) {
            InvokeInstruction inv = (InvokeInstruction)ins;
            if (!frame.isValid() || !this.getInstanceValue(frame, inv, cpg).isInstance()) {
                return false;
            }
            try {
                return inv.getName(cpg).equals("close") && inv.getSignature(cpg).equals("()V") && Hierarchy.isSubtype((String)inv.getClassName(cpg), (String)this.streamBase);
            }
            catch (ClassNotFoundException e) {
                lookupFailureCallback.reportMissingClass(e);
                return false;
            }
        }
        return false;
    }

    private ResourceValue getInstanceValue(ResourceValueFrame frame, InvokeInstruction inv, ConstantPoolGen cpg) {
        int numConsumed = inv.consumeStack(cpg);
        if (numConsumed == -2) {
            throw new IllegalStateException();
        }
        return (ResourceValue)frame.getValue(frame.getNumSlots() - numConsumed);
    }

    private boolean matchMethod(InvokeInstruction inv, ConstantPoolGen cpg, String className, String methodName) {
        return inv.getClassName(cpg).equals(className) && inv.getName(cpg).equals(methodName);
    }
}

