/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ResourceTrackingDetector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysisTestDriver;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.ValueNumber;
import edu.umd.cs.findbugs.ba.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.ValueNumberFrame;
import edu.umd.cs.findbugs.detect.Lock;
import java.util.BitSet;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUnreleasedLock
extends ResourceTrackingDetector<Lock, LockResourceTracker> {
    private static final boolean DEBUG = Boolean.getBoolean("ful.debug");
    private static int numAcquires = 0;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$detect$FindUnreleasedLock;

    public FindUnreleasedLock(BugReporter bugReporter) {
        super(bugReporter);
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet.get(182) || bytecodeSet.get(185);
    }

    public LockResourceTracker getResourceTracker(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        return new LockResourceTracker((RepositoryLookupFailureCallback)this.bugReporter, classContext.getValueNumberDataflow(method));
    }

    public void inspectResult(JavaClass javaClass, MethodGen methodGen, CFG cfg, Dataflow<ResourceValueFrame, ResourceValueAnalysis<Lock>> dataflow, Lock resource) {
        ResourceValueFrame exitFrame = (ResourceValueFrame)dataflow.getResultFact(cfg.getExit());
        int exitStatus = exitFrame.getStatus();
        if (exitStatus == 1 || exitStatus == 2) {
            int priority;
            String bugType;
            if (exitStatus == 1) {
                bugType = "UL_UNRELEASED_LOCK";
                priority = 1;
            } else {
                bugType = "UL_UNRELEASED_LOCK_EXCEPTION_PATH";
                priority = 2;
            }
            String sourceFile = javaClass.getSourceFileName();
            this.bugReporter.reportBug(new BugInstance(bugType, priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, resource.getLocation().getHandle()));
        }
    }

    public void report() {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("numAcquires=").append(numAcquires).toString());
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$detect$FindUnreleasedLock == null ? (class$edu$umd$cs$findbugs$detect$FindUnreleasedLock = FindUnreleasedLock.class$("edu.umd.cs.findbugs.detect.FindUnreleasedLock")) : class$edu$umd$cs$findbugs$detect$FindUnreleasedLock).getName()).append(" <class file> <method name> <bytecode offset>").toString());
            System.exit(1);
        }
        String classFile = argv[0];
        String methodName = argv[1];
        int offset = Integer.parseInt(argv[2]);
        ResourceValueAnalysisTestDriver<Lock, LockResourceTracker> driver = new ResourceValueAnalysisTestDriver<Lock, LockResourceTracker>(){

            public LockResourceTracker createResourceTracker(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
                RepositoryLookupFailureCallback lookupFailureCallback = classContext.getLookupFailureCallback();
                return new LockResourceTracker(lookupFailureCallback, vnaDataflow);
            }

            public /* synthetic */ ResourceTracker createResourceTracker(ClassContext x0, Method x1) throws CFGBuilderException, DataflowAnalysisException {
                return this.createResourceTracker(x0, x1);
            }
        };
        driver.execute(classFile, methodName, offset);
    }

    public /* synthetic */ void analyzeMethod(ClassContext x0, Method x1, ResourceTracker x2, Map x3) throws CFGBuilderException, DataflowAnalysisException {
        super.analyzeMethod(x0, x1, (ResourceTracker)((LockResourceTracker)x2), x3);
    }

    public /* synthetic */ void inspectResult(JavaClass x0, MethodGen x1, CFG x2, Dataflow x3, Object x4) {
        this.inspectResult(x0, x1, x2, (Dataflow<ResourceValueFrame, ResourceValueAnalysis<Lock>>)x3, (Lock)((Object)x4));
    }

    public /* synthetic */ ResourceTracker getResourceTracker(ClassContext x0, Method x1) throws DataflowAnalysisException, CFGBuilderException {
        return this.getResourceTracker(x0, x1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LockResourceTracker
    implements ResourceTracker<Lock> {
        private RepositoryLookupFailureCallback lookupFailureCallback;
        private ValueNumberDataflow vnaDataflow;

        public LockResourceTracker(RepositoryLookupFailureCallback lookupFailureCallback, ValueNumberDataflow vnaDataflow) {
            this.lookupFailureCallback = lookupFailureCallback;
            this.vnaDataflow = vnaDataflow;
        }

        public Lock isResourceCreation(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) throws DataflowAnalysisException {
            InvokeInstruction inv = LockResourceTracker.toInvokeInstruction(handle.getInstruction());
            if (inv == null) {
                return null;
            }
            String className = inv.getClassName(cpg);
            String methodName = inv.getName(cpg);
            String methodSig = inv.getSignature(cpg);
            try {
                if (methodName.equals("lock") && methodSig.equals("()V") && Hierarchy.isSubtype((String)className, (String)"java.util.concurrent.Lock")) {
                    Location location = new Location(handle, basicBlock);
                    ValueNumberFrame frame = this.vnaDataflow.getFactAtLocation(location);
                    ValueNumber lockValue = (ValueNumber)frame.getTopValue();
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("Lock value is ").append(lockValue.getNumber()).append(", frame=").append(frame.toString()).toString());
                    }
                    if (DEBUG) {
                        ++numAcquires;
                    }
                    return new Lock(location, className, lockValue);
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
            return null;
        }

        public boolean isResourceClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Lock resource, ResourceValueFrame frame) throws DataflowAnalysisException {
            InvokeInstruction inv = LockResourceTracker.toInvokeInstruction(handle.getInstruction());
            if (inv == null) {
                return false;
            }
            String className = inv.getClassName(cpg);
            String methodName = inv.getName(cpg);
            String methodSig = inv.getSignature(cpg);
            ResourceValue topValue = (ResourceValue)frame.getTopValue();
            if (!topValue.isInstance()) {
                return false;
            }
            try {
                if (methodName.equals("unlock") && methodSig.equals("()V") && Hierarchy.isSubtype((String)className, (String)"java.util.concurrent.Lock")) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
            return false;
        }

        public ResourceValueFrameModelingVisitor createVisitor(Lock resource, ConstantPoolGen cpg) {
            return new LockFrameModelingVisitor(cpg, this, resource, this.vnaDataflow);
        }

        public boolean ignoreImplicitExceptions(Lock resource) {
            return false;
        }

        private static final InvokeInstruction toInvokeInstruction(Instruction ins) {
            short opcode = ins.getOpcode();
            if (opcode != 182 && opcode != 185) {
                return null;
            }
            return (InvokeInstruction)ins;
        }

        public /* synthetic */ boolean ignoreImplicitExceptions(Object x0) {
            return this.ignoreImplicitExceptions((Lock)((Object)x0));
        }

        public /* synthetic */ ResourceValueFrameModelingVisitor createVisitor(Object x0, ConstantPoolGen x1) {
            return this.createVisitor((Lock)((Object)x0), x1);
        }

        public /* synthetic */ boolean isResourceClose(BasicBlock x0, InstructionHandle x1, ConstantPoolGen x2, Object x3, ResourceValueFrame x4) throws DataflowAnalysisException {
            return this.isResourceClose(x0, x1, x2, (Lock)((Object)x3), x4);
        }

        public /* synthetic */ Object isResourceCreation(BasicBlock x0, InstructionHandle x1, ConstantPoolGen x2) throws DataflowAnalysisException {
            return this.isResourceCreation(x0, x1, x2);
        }
    }

    private static class LockFrameModelingVisitor
    extends ResourceValueFrameModelingVisitor {
        private LockResourceTracker resourceTracker;
        private Lock lock;
        private ValueNumberDataflow vnaDataflow;

        public LockFrameModelingVisitor(ConstantPoolGen cpg, LockResourceTracker resourceTracker, Lock lock, ValueNumberDataflow vnaDataflow) {
            super(cpg);
            this.resourceTracker = resourceTracker;
            this.lock = lock;
            this.vnaDataflow = vnaDataflow;
        }

        public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock) throws DataflowAnalysisException {
            Instruction ins = handle.getInstruction();
            ConstantPoolGen cpg = this.getCPG();
            ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
            int status = -1;
            Location creationPoint = this.lock.getLocation();
            if (handle == creationPoint.getHandle() && basicBlock == creationPoint.getBasicBlock()) {
                status = 1;
            } else if (this.resourceTracker.isResourceClose(basicBlock, handle, cpg, this.lock, frame)) {
                status = 3;
            }
            ins.accept((Visitor)this);
            int updatedNumSlots = frame.getNumSlots();
            ValueNumberFrame vnaFrame = this.vnaDataflow.getFactAfterLocation(new Location(handle, basicBlock));
            if (DEBUG) {
                System.out.println("vna frame after instruction: " + vnaFrame.toString());
            }
            for (int i = 0; i < updatedNumSlots; ++i) {
                if (!((ValueNumber)vnaFrame.getValue(i)).equals(this.lock.getLockValue())) continue;
                if (DEBUG) {
                    System.out.println("Saw lock value!");
                }
                frame.setValue(i, (Object)ResourceValue.instance());
            }
            if (status != -1) {
                frame.setStatus(status);
            }
        }

        protected boolean instanceEscapes(InvokeInstruction inv, int instanceArgNum) {
            return false;
        }
    }
}

