/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

public class FindMaskedFields
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("fmf.debug");
    private static final Set<String> ignoredFields = new HashSet<String>();
    private BugReporter bugReporter;
    private int numParms;
    private Set<String> classFields;

    public FindMaskedFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.classFields = new HashSet<String>();
    }

    public void visit(JavaClass obj) {
        String fieldName;
        if (DEBUG) {
            System.out.println("-------- Analyzing class " + obj.getClassName() + "--------");
        }
        if (obj.isInterface()) {
            return;
        }
        this.classFields.clear();
        Field[] fields = obj.getFields();
        for (int f = 0; f < fields.length; ++f) {
            fieldName = fields[f].getName();
            if (DEBUG) {
                System.out.println("Class field " + fieldName);
            }
            this.classFields.add(fieldName);
        }
        try {
            JavaClass[] superClasses = Repository.getSuperClasses((JavaClass)obj);
            for (int c = 0; c < superClasses.length; ++c) {
                fields = superClasses[c].getFields();
                for (int f = 0; f < fields.length; ++f) {
                    Field fld = fields[f];
                    if (fld.isPrivate() || (fieldName = fld.getName()).startsWith("class$") || ignoredFields.contains(fieldName) || !this.classFields.contains(fieldName)) continue;
                    FieldAnnotation fa = new FieldAnnotation(this.getDottedClassName(), fieldName, fld.getSignature(), fld.isStatic());
                    FieldAnnotation superField = new FieldAnnotation(superClasses[c].getClassName(), fieldName, fld.getSignature(), fld.isStatic());
                    this.bugReporter.reportBug(new BugInstance("MF_CLASS_MASKS_FIELD", 2).addClass((PreorderVisitor)this).addField(fa).addField(superField).describe("FIELD_MASKED"));
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.numParms = obj.getArgumentTypes().length;
    }

    public void visit(LocalVariableTable obj) {
        LocalVariable[] vars = obj.getLocalVariableTable();
        for (int v = this.numParms + 1; v < vars.length; ++v) {
            LocalVariable var = vars[v];
            String varName = var.getName();
            if (!this.classFields.contains(varName)) continue;
            FieldAnnotation fa = new FieldAnnotation(this.getDottedClassName(), varName, var.getSignature(), false);
            MethodAnnotation ma = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
            if (var.getStartPC() <= 0) continue;
            this.bugReporter.reportBug(new BugInstance("MF_METHOD_MASKS_FIELD", 2).addClass((PreorderVisitor)this).addMethod(ma).addField(fa).addSourceLine((PreorderVisitor)this, var.getStartPC() - 1));
        }
        super.visit(obj);
    }

    static {
        ignoredFields.add("serialVersionUID");
    }
}

