/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import org.apache.bcel.classfile.Method;

public class FindDoubleCheck
extends BytecodeScanningDetector
implements Constants2 {
    int stage = 0;
    int startPC;
    int endPC;
    int count;
    boolean sawMonitorEnter;
    HashSet<FieldAnnotation> fields = new HashSet();
    HashSet<FieldAnnotation> twice = new HashSet();
    private BugReporter bugReporter;

    public FindDoubleCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.fields.clear();
        this.twice.clear();
        this.stage = 0;
        this.count = 0;
        this.sawMonitorEnter = false;
    }

    public void sawOpcode(int seen) {
        FieldAnnotation f;
        if (seen == 194) {
            this.sawMonitorEnter = true;
        }
        if (seen == 180 || seen == 178) {
            f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
            if (!this.sawMonitorEnter) {
                this.fields.add(f);
                this.startPC = this.getPC();
            } else if (this.fields.contains(f)) {
                this.twice.add(f);
            }
        }
        switch (this.stage) {
            case 0: {
                if (seen == 198 || seen == 199) {
                    ++this.stage;
                }
                this.count = 0;
                break;
            }
            case 1: {
                if (seen == 194) {
                    ++this.stage;
                    break;
                }
                ++this.count;
                if (this.count <= 10) break;
                this.stage = 0;
                break;
            }
            case 2: {
                if (seen == 198 || seen == 199) {
                    this.endPC = this.getPC();
                    ++this.stage;
                    break;
                }
                ++this.count;
                if (this.count <= 10) break;
                this.stage = 0;
                break;
            }
            case 3: {
                if (seen != 181 && seen != 179 || !this.fields.contains(f = FieldAnnotation.fromReferencedField((DismantleBytecode)this)) || this.getNameConstantOperand().startsWith("class$")) break;
                this.bugReporter.reportBug(new BugInstance("DC_DOUBLECHECK", 2).addClassAndMethod((PreorderVisitor)this).addField(f).describe("FIELD_ON").addSourceLineRange((PreorderVisitor)this, this.startPC, this.endPC));
                ++this.stage;
                break;
            }
        }
    }
}

