/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.pugh.visitclass.Constants2;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.bcel.classfile.Code;

public class InitializationChain
extends BytecodeScanningDetector
implements Constants2 {
    Set<String> requires = new TreeSet<String>();
    Map<String, Set<String>> classRequires = new TreeMap<String, Set<String>>();
    private BugReporter bugReporter;
    private boolean instanceCreated;
    private int instanceCreatedPC;
    private boolean instanceCreatedWarningGiven;
    private static final boolean DEBUG = Boolean.getBoolean("ic.debug");

    public InitializationChain(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.instanceCreated = false;
        this.instanceCreatedWarningGiven = false;
        if (!this.methodName.equals("<clinit>")) {
            return;
        }
        super.visit(obj);
        this.requires.remove(this.betterClassName);
        if (this.betterClassName.equals("java.lang.System")) {
            this.requires.add("java.io.FileInputStream");
            this.requires.add("java.io.FileOutputStream");
            this.requires.add("java.io.BufferedInputStream");
            this.requires.add("java.io.BufferedOutputStream");
            this.requires.add("java.io.PrintStream");
        }
        if (!this.requires.isEmpty()) {
            this.classRequires.put(this.betterClassName, this.requires);
            this.requires = new TreeSet<String>();
        }
    }

    public void sawOpcode(int seen) {
        if (seen != 179 || !this.classConstant.equals(this.className)) {
            if (seen == 187 && this.classConstant.equals(this.className)) {
                this.instanceCreated = true;
                this.instanceCreatedPC = this.PC;
            } else if ((seen == 179 || seen == 178 || seen == 184 || seen == 187) && this.PC + 6 < this.codeBytes.length) {
                this.requires.add(this.betterClassConstant);
            }
        }
    }

    public void compute() {
        String c;
        Set<String> allClasses = this.classRequires.keySet();
        TreeSet<String> emptyClasses = new TreeSet<String>();
        Iterator<String> i = allClasses.iterator();
        while (i.hasNext()) {
            c = i.next();
            Set<String> needs = this.classRequires.get(c);
            needs.retainAll(allClasses);
            TreeSet extra = new TreeSet();
            Iterator<String> j = needs.iterator();
            while (j.hasNext()) {
                extra.addAll(this.classRequires.get(j.next()));
            }
            needs.addAll(extra);
            needs.retainAll(allClasses);
            this.classRequires.put(c, needs);
            if (!needs.isEmpty()) continue;
            emptyClasses.add(c);
        }
        i = emptyClasses.iterator();
        while (i.hasNext()) {
            c = i.next();
            this.classRequires.remove(c);
        }
    }

    public void report() {
        if (DEBUG) {
            System.out.println("Finishing computation");
        }
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        Set<String> allClasses = this.classRequires.keySet();
        Iterator<String> i = allClasses.iterator();
        while (i.hasNext()) {
            String c = i.next();
            if (DEBUG) {
                System.out.println("Class " + c + " requires:");
            }
            Iterator<String> j = this.classRequires.get(c).iterator();
            while (j.hasNext()) {
                Set<String> s;
                String needs = j.next();
                if (DEBUG) {
                    System.out.println("  " + needs);
                }
                if ((s = this.classRequires.get(needs)) == null || !s.contains(c) || c.compareTo(needs) >= 0) continue;
                this.bugReporter.reportBug(new BugInstance("IC_INIT_CIRCULARITY", 2).addClass(c).addClass(needs));
            }
        }
    }
}

