/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.daveho.ba.BasicBlock;
import edu.umd.cs.daveho.ba.CFG;
import edu.umd.cs.daveho.ba.CFGBuilderException;
import edu.umd.cs.daveho.ba.ClassContext;
import edu.umd.cs.daveho.ba.DataflowAnalysisException;
import edu.umd.cs.daveho.ba.Location;
import edu.umd.cs.daveho.ba.LocationScanner;
import edu.umd.cs.daveho.ba.LockCount;
import edu.umd.cs.daveho.ba.LockCountDataflow;
import edu.umd.cs.findbugs.AnalysisException;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CallSite;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SelfCalls;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class FindInconsistentSync
implements Detector {
    private static final boolean DEBUG = Boolean.getBoolean("fis.debug");
    private static final boolean ANY_LOCKS = Boolean.getBoolean("fis.anylocks");
    private static final boolean IGNORE_CALL_SITES = Boolean.getBoolean("fis.ignorecallsites");
    private BugReporter bugReporter;
    private HashMap<FieldAnnotation, FieldStats> statMap = new LinkedHashMap<FieldAnnotation, FieldStats>();
    private HashSet<FieldAnnotation> publicFields = new HashSet();
    private HashSet<FieldAnnotation> volatileAndFinalFields = new HashSet();
    private HashSet<FieldAnnotation> writtenOutsideOfConstructor = new HashSet();
    private HashSet<FieldAnnotation> localLocks = new HashSet();
    private JavaClass javaClass;
    private boolean inConstructor;
    private HashSet<MethodGen> lockedPrivateMethods = new HashSet();
    private SelfCalls selfCalls;

    public FindInconsistentSync(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            try {
                this.startClass(classContext);
                JavaClass jclass = classContext.getJavaClass();
                Method[] methodList = jclass.getMethods();
                for (int i = 0; i < methodList.length; ++i) {
                    Method method = methodList[i];
                    final MethodGen methodGen = classContext.getMethodGen(method);
                    if (methodGen == null) continue;
                    this.inConstructor = FindInconsistentSync.isConstructor(methodGen.getName());
                    if (this.inConstructor) continue;
                    CFG cfg = classContext.getCFG(method);
                    final LockCountDataflow dataflow = FindInconsistentSync.getLockCountDataflow(classContext, method);
                    new LocationScanner(cfg).scan(new LocationScanner.Callback(){

                        public void visitLocation(Location location) {
                            FindInconsistentSync.this.visitInstruction(dataflow, location.getHandle(), location.getBasicBlock(), methodGen);
                        }
                    });
                }
            }
            finally {
                this.finishClass();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException("FindInconsistentSync caught exception: " + e.toString(), (Throwable)e);
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException("FindInconsistentSync caught exception: " + e.toString(), (Throwable)e);
        }
    }

    public void startClass(ClassContext classContext) {
        this.javaClass = classContext.getJavaClass();
        String className = this.javaClass.getClassName();
        Field[] jfields = this.javaClass.getFields();
        for (int i = 0; i < jfields.length; ++i) {
            Field jfield = jfields[i];
            String fieldName = jfield.getName();
            String fieldSig = jfield.getSignature();
            boolean isStatic = jfield.isStatic();
            if (jfield.isPublic()) {
                this.publicFields.add(new FieldAnnotation(className, fieldName, fieldSig, isStatic));
                continue;
            }
            if (!jfield.isVolatile() && !jfield.isFinal()) continue;
            this.volatileAndFinalFields.add(new FieldAnnotation(className, fieldName, fieldSig, isStatic));
        }
        if (IGNORE_CALL_SITES) {
            return;
        }
        this.selfCalls = new SelfCalls(classContext){

            public boolean wantCallsFor(Method method) {
                return !method.isPublic();
            }
        };
        try {
            this.selfCalls.execute();
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException(e.getMessage());
        }
        if (!this.selfCalls.hasSynchronization()) {
            return;
        }
        try {
            Iterator i = this.selfCalls.calledMethodIterator();
            while (i.hasNext()) {
                Method called = (Method)i.next();
                Set callSiteSet = this.selfCalls.getCallSites(called);
                boolean allSitesLocked = true;
                Iterator j = callSiteSet.iterator();
                while (j.hasNext()) {
                    CallSite callSite = (CallSite)j.next();
                    Method method = callSite.getMethod();
                    BasicBlock basicBlock = callSite.getBasicBlock();
                    InstructionHandle handle = callSite.getHandle();
                    if (FindInconsistentSync.isConstructor(method.getName())) continue;
                    try {
                        CFG cfg = classContext.getCFG(method);
                    }
                    catch (CFGBuilderException e) {
                        throw new AnalysisException(e.getMessage());
                    }
                    MethodGen methodGen = classContext.getMethodGen(method);
                    LockCountDataflow dataflow = FindInconsistentSync.getLockCountDataflow(classContext, method);
                    LockCount lockCount = FindInconsistentSync.getLockCount(dataflow, handle, basicBlock);
                    if (lockCount.getCount() > 0) continue;
                    if (DEBUG) {
                        System.out.println("Unlocked call to " + this.javaClass.getClassName() + "." + called.getName() + " from method " + methodGen.getClassName() + "." + methodGen.getName());
                    }
                    allSitesLocked = false;
                    break;
                }
                if (!allSitesLocked) continue;
                MethodGen calledMG = classContext.getMethodGen(called);
                if (DEBUG) {
                    System.out.println("All call sites locked for " + calledMG.getClassName() + "." + calledMG.getName());
                }
                this.lockedPrivateMethods.add(calledMG);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException("FindInconsistentSync caught exception: " + e.toString(), (Throwable)e);
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException("FindInconsistentSync caught exception: " + e.toString(), (Throwable)e);
        }
    }

    public void finishClass() {
        this.lockedPrivateMethods.clear();
        this.selfCalls = null;
    }

    private static boolean isConstructor(String methodName) {
        return methodName.equals("<init>") || methodName.equals("<clinit>") || methodName.equals("readObject") || methodName.equals("clone") || methodName.equals("close") || methodName.equals("finalize");
    }

    private static LockCountDataflow getLockCountDataflow(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        return ANY_LOCKS ? classContext.getAnyLockCountDataflow(method) : classContext.getThisLockCountDataflow(method);
    }

    public void visitInstruction(LockCountDataflow dataflow, InstructionHandle handle, BasicBlock bb, MethodGen methodGen) {
        try {
            if (this.inConstructor) {
                throw new IllegalStateException("visiting instruction in constructor!");
            }
            boolean callerAlwaysLocked = this.lockedPrivateMethods.contains(methodGen);
            ConstantPoolGen cpg = methodGen.getConstantPool();
            Instruction ins = handle.getInstruction();
            FieldAnnotation field = FieldAnnotation.isRead((Instruction)ins, (ConstantPoolGen)cpg);
            if (field != null) {
                FieldStats stats = this.getStats(field);
                LockCount lockCount = FindInconsistentSync.getLockCount(dataflow, handle, bb);
                if (lockCount.getCount() > 0 || callerAlwaysLocked) {
                    if (DEBUG) {
                        this.debug(field, methodGen, "R/L");
                    }
                    ++stats.nReadLocked;
                    if (this.isLocal(field)) {
                        this.localLocks.add(field);
                    }
                } else if (lockCount.getCount() == 0) {
                    if (DEBUG) {
                        this.debug(field, methodGen, "R/U");
                    }
                    ++stats.nReadUnlocked;
                    this.addUnsyncAccess(stats, methodGen, handle);
                }
            } else {
                field = FieldAnnotation.isWrite((Instruction)ins, (ConstantPoolGen)cpg);
                if (field != null) {
                    this.writtenOutsideOfConstructor.add(field);
                    FieldStats stats = this.getStats(field);
                    LockCount lockCount = FindInconsistentSync.getLockCount(dataflow, handle, bb);
                    if (lockCount.getCount() > 0 || callerAlwaysLocked) {
                        if (DEBUG) {
                            this.debug(field, methodGen, "W/L");
                        }
                        ++stats.nWriteLocked;
                        if (this.isLocal(field)) {
                            this.localLocks.add(field);
                        }
                    } else if (lockCount.getCount() == 0) {
                        if (DEBUG) {
                            this.debug(field, methodGen, "W/U");
                        }
                        ++stats.nWriteUnlocked;
                        this.addUnsyncAccess(stats, methodGen, handle);
                    }
                }
            }
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException(e.toString());
        }
    }

    private void addUnsyncAccess(FieldStats stats, MethodGen methodGen, InstructionHandle handle) {
        String sourceFile = this.javaClass.getSourceFileName();
        SourceLineAnnotation accessSourceLine = SourceLineAnnotation.fromVisitedInstruction((MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
        if (accessSourceLine != null) {
            stats.unsyncAccessList.add(accessSourceLine);
        }
    }

    private void debug(FieldAnnotation field, MethodGen mg, String accessType) {
        String fullMethodName = this.javaClass.getClassName() + "." + mg.getName() + " : " + mg.getSignature();
        System.out.println(accessType + "\t" + fullMethodName + "\t" + field.toString() + " (IS2)");
    }

    private FieldStats getStats(FieldAnnotation field) {
        FieldStats stats = this.statMap.get(field);
        if (stats == null) {
            stats = new FieldStats();
            this.statMap.put(field, stats);
        }
        return stats;
    }

    private static LockCount getLockCount(LockCountDataflow dataflow, InstructionHandle handle, BasicBlock bb) throws DataflowAnalysisException {
        return dataflow.getFactAtLocation(new Location(handle, bb));
    }

    private boolean isLocal(FieldAnnotation field) {
        return field.getClassName().equals(this.javaClass.getClassName());
    }

    public void report() {
        int noLocked = 0;
        int noUnlocked = 0;
        int nPublic = 0;
        int nVolatileOrFinal = 0;
        int couldBeFinal = 0;
        int mostlyUnlocked = 0;
        int noLocalLocks = 0;
        Iterator<Map.Entry<FieldAnnotation, FieldStats>> i = this.statMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<FieldAnnotation, FieldStats> entry = i.next();
            FieldAnnotation field = entry.getKey();
            FieldStats stats = entry.getValue();
            int locked = stats.nReadLocked + stats.nWriteLocked;
            int biasedLocked = stats.nReadLocked + 2 * stats.nWriteLocked;
            int unlocked = stats.nReadUnlocked + stats.nWriteUnlocked;
            int biasedUnlocked = stats.nReadUnlocked + 2 * stats.nWriteUnlocked;
            int writes = stats.nWriteLocked + stats.nWriteUnlocked;
            if (locked == 0) {
                ++noLocked;
                continue;
            }
            if (unlocked == 0) {
                ++noUnlocked;
                continue;
            }
            if (stats.nReadUnlocked > 0 && 2 * biasedUnlocked > biasedLocked) {
                ++mostlyUnlocked;
                continue;
            }
            if (this.publicFields.contains(field)) {
                ++nPublic;
                continue;
            }
            if (this.volatileAndFinalFields.contains(field)) {
                ++nVolatileOrFinal;
                continue;
            }
            if (!this.writtenOutsideOfConstructor.contains(field)) {
                ++couldBeFinal;
                continue;
            }
            if (!this.localLocks.contains(field)) {
                ++noLocalLocks;
                continue;
            }
            int freq = 100 * locked / (locked + unlocked);
            BugInstance bugInstance = new BugInstance("IS2_INCONSISTENT_SYNC", 2).addClass(field.getClassName()).addField(field).addInt(freq).describe("INT_SYNC_PERCENT");
            Iterator<SourceLineAnnotation> j = stats.unsyncAccessList.iterator();
            while (j.hasNext()) {
                SourceLineAnnotation accessSourceLine = j.next();
                bugInstance.addSourceLine(accessSourceLine).describe("SOURCE_LINE_UNSYNC_ACCESS");
            }
            this.bugReporter.reportBug(bugInstance);
            if (!DEBUG) continue;
            System.out.println(freq + "\t" + stats.nReadLocked + "\t" + stats.nWriteLocked + "\t" + stats.nReadUnlocked + "\t" + stats.nWriteUnlocked + "\t" + field.toString());
        }
        if (DEBUG) {
            int total = this.statMap.size();
            System.out.println("        Total fields: " + total);
            System.out.println("  No locked accesses: " + noLocked);
            System.out.println("No unlocked accesses: " + noUnlocked);
            System.out.println("     Mostly unlocked: " + mostlyUnlocked);
            System.out.println("       public fields: " + nPublic);
            if (couldBeFinal > 0) {
                System.out.println("      could be Final: " + couldBeFinal);
            }
            System.out.println("   volatile or final: " + nVolatileOrFinal);
            System.out.println("      no local locks: " + noLocalLocks);
            System.out.println(" questionable fields: " + (total - noLocked - noUnlocked - nPublic - nVolatileOrFinal - couldBeFinal - noLocalLocks - mostlyUnlocked));
        }
    }

    private static class FieldStats {
        public int nReadLocked = 0;
        public int nReadUnlocked = 0;
        public int nWriteLocked = 0;
        public int nWriteUnlocked = 0;
        public Set<SourceLineAnnotation> unsyncAccessList = new LinkedHashSet<SourceLineAnnotation>();
    }
}

