/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.daveho.ba.ClassContext;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.pugh.visitclass.BetterVisitor;
import edu.umd.cs.pugh.visitclass.Constants2;
import edu.umd.cs.pugh.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public class DroppedException
extends PreorderVisitor
implements Detector,
Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("de.debug");
    Set<String> reported = new HashSet<String>();
    Set<String> causes = new HashSet<String>();
    Set<String> checkedCauses = new HashSet<String>();
    private BugReporter bugReporter;

    public DroppedException(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }

    boolean isChecked(String c) {
        if (!this.causes.add(c)) {
            return this.checkedCauses.contains(c);
        }
        try {
            if (Repository.instanceOf((String)c, (String)"java.lang.Exception") && !Repository.instanceOf((String)c, (String)"java.lang.RuntimeException")) {
                this.checkedCauses.add(c);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return false;
        }
    }

    public void visit(Code obj) {
        CodeException[] exp = obj.getExceptionTable();
        if (exp == null) {
            return;
        }
        byte[] code = obj.getCode();
        for (int i = 0; i < exp.length; ++i) {
            String key;
            String c;
            int opcode;
            int handled = exp[i].getHandlerPC();
            int start = exp[i].getStartPC();
            int end = exp[i].getEndPC();
            int cause = exp[i].getCatchType();
            boolean exitInTryBlock = false;
            for (int j = start; j <= end; j += 1 + NO_OF_OPERANDS[opcode]) {
                opcode = this.asUnsignedByte(code[j]);
                if (opcode >= 172 && opcode <= 177 || opcode >= 153 && opcode <= 167 && (opcode != 167 || j < end)) {
                    exitInTryBlock = true;
                    break;
                }
                if (NO_OF_OPERANDS[opcode] >= 0) continue;
                exitInTryBlock = true;
                break;
            }
            if (exitInTryBlock) continue;
            if (cause == 0) {
                c = "Throwable";
            } else {
                c = Utility.compactClassName((String)this.constant_pool.getConstantString(cause, (byte)7), (boolean)false);
                if (!this.isChecked(c)) continue;
            }
            if (handled < 5) continue;
            opcode = this.asUnsignedByte(code[handled]);
            boolean drops = false;
            if (opcode >= 75 && opcode <= 78 && this.asUnsignedByte(code[handled + 1]) == 177) {
                if (DEBUG) {
                    System.out.println("Drop 1");
                }
                drops = true;
            }
            if (handled + 2 < code.length && opcode == 58 && this.asUnsignedByte(code[handled + 2]) == 177) {
                drops = true;
                if (DEBUG) {
                    System.out.println("Drop 2");
                }
            }
            if (handled + 3 < code.length && !exitInTryBlock) {
                int offsetAfter;
                int offsetBefore;
                if (opcode >= 75 && opcode <= 78 && this.asUnsignedByte(code[handled - 3]) == 167 && (offsetBefore = this.asUnsignedByte(code[handled - 2]) << 8 | this.asUnsignedByte(code[handled - 1])) == 4) {
                    drops = true;
                    if (DEBUG) {
                        System.out.println("Drop 3");
                    }
                }
                if (opcode == 58 && this.asUnsignedByte(code[handled - 3]) == 167 && (offsetBefore = this.asUnsignedByte(code[handled - 2]) << 8 | this.asUnsignedByte(code[handled - 1])) == 5) {
                    drops = true;
                    if (DEBUG) {
                        System.out.println("Drop 4");
                    }
                }
                if (opcode >= 75 && opcode <= 78 && this.asUnsignedByte(code[handled + 1]) == 167 && this.asUnsignedByte(code[handled - 3]) == 167) {
                    offsetBefore = this.asUnsignedByte(code[handled - 2]) << 8 | this.asUnsignedByte(code[handled - 1]);
                    offsetAfter = this.asUnsignedByte(code[handled + 2]) << 8 | this.asUnsignedByte(code[handled + 3]);
                    if (offsetAfter > 0 && offsetAfter + 4 == offsetBefore) {
                        drops = true;
                        if (DEBUG) {
                            System.out.println("Drop 5");
                        }
                    }
                }
                if (opcode == 58 && this.asUnsignedByte(code[handled + 2]) == 167 && this.asUnsignedByte(code[handled - 3]) == 167) {
                    offsetBefore = this.asUnsignedByte(code[handled - 2]) << 8 | this.asUnsignedByte(code[handled - 1]);
                    offsetAfter = this.asUnsignedByte(code[handled + 3]) << 8 | this.asUnsignedByte(code[handled + 4]);
                    if (offsetAfter > 0 && offsetAfter + 5 == offsetBefore) {
                        drops = true;
                        if (DEBUG) {
                            System.out.println("Drop 6");
                        }
                    }
                }
            }
            if (end - start < 5 || !drops || c.equals("java.lang.InterruptedException") || c.equals("java.lang.CloneNotSupportedException") || !this.reported.add(key = (exitInTryBlock ? "mightDrop," : "mightIgnore,") + this.betterMethodName + "," + c)) continue;
            this.bugReporter.reportBug(new BugInstance(exitInTryBlock ? "DE_MIGHT_DROP" : "DE_MIGHT_IGNORE", 2).addClassAndMethod((BetterVisitor)this).addSourceLine((BetterVisitor)this, handled).addClass(c).describe("CLASS_EXCEPTION"));
        }
    }
}

