/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class MethodReturnCheck
extends BytecodeScanningDetector {
    private static final boolean DEBUG = Boolean.getBoolean("mrc.debug");
    private static final int SCAN = 0;
    private static final int SAW_INVOKE = 1;
    private static final BitSet INVOKE_OPCODE_SET = new BitSet();
    boolean previousOpcodeWasNEW;
    private BugReporter bugReporter;
    private ClassContext classContext;
    private CheckReturnAnnotationDatabase checkReturnAnnotationDatabase;
    private Method method;
    private XMethod callSeen;
    private int state;
    private int callPC;
    private String className;
    private String methodName;
    private String signature;

    public MethodReturnCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        this.checkReturnAnnotationDatabase = AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase();
        super.visitClassContext(classContext);
        this.classContext = null;
    }

    public void visit(Method method) {
        this.method = method;
    }

    public void visitCode(Code code) {
        if (DEBUG) {
            System.out.println("Visiting " + this.method);
        }
        super.visitCode(code);
    }

    public void sawOpcode(int seen) {
        CheckReturnValueAnnotation annotation;
        if (DEBUG) {
            System.out.println(this.state + " " + OPCODE_NAMES[seen]);
        }
        if (this.state == 1 && this.isPop(seen)) {
            annotation = this.checkReturnAnnotationDatabase.getResolvedAnnotation((Object)this.callSeen, false);
            if (annotation != null && annotation != CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE) {
                int popPC = this.getPC();
                if (DEBUG) {
                    System.out.println("Saw POP @" + popPC);
                }
                int catchSize = this.getSizeOfSurroundingTryBlock(popPC);
                int priority = annotation.getPriority();
                if (catchSize <= 1) {
                    priority += 2;
                } else if (catchSize <= 2) {
                    ++priority;
                }
                if (!this.checkReturnAnnotationDatabase.annotationIsDirect((Object)this.callSeen) && !this.callSeen.getSignature().endsWith(this.callSeen.getClassName().replace('.', '/') + ";")) {
                    ++priority;
                }
                BugInstance warning = new BugInstance((Detector)this, "RV_RETURN_VALUE_IGNORED", priority).addClassAndMethod((PreorderVisitor)this).addMethod(this.className, this.methodName, this.signature, seen == 184).describe("METHOD_CALLED").addSourceLine((BytecodeScanningDetector)this, this.callPC);
                this.bugReporter.reportBug(warning);
            }
            this.state = 0;
        } else if (INVOKE_OPCODE_SET.get(seen)) {
            this.callPC = this.getPC();
            this.className = this.getDottedClassConstantOperand();
            this.methodName = this.getNameConstantOperand();
            this.signature = this.getSigConstantOperand();
            this.callSeen = XFactory.createXMethod((String)this.className, (String)this.methodName, (String)this.signature, (seen == 184 ? 1 : 0) != 0);
            this.state = 1;
            if (DEBUG) {
                System.out.println("  invoking " + this.callSeen);
            }
        } else {
            this.state = 0;
        }
        if (seen == 187) {
            this.previousOpcodeWasNEW = true;
        } else {
            if (seen == 183 && this.previousOpcodeWasNEW && (annotation = this.checkReturnAnnotationDatabase.getResolvedAnnotation((Object)this.callSeen, false)) != null && annotation != CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE) {
                int priority = annotation.getPriority();
                if (!this.checkReturnAnnotationDatabase.annotationIsDirect((Object)this.callSeen) && !this.callSeen.getSignature().endsWith(this.callSeen.getClassName().replace('.', '/') + ";")) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "RV_RETURN_VALUE_IGNORED", priority).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).describe("METHOD_CALLED").addSourceLine((BytecodeScanningDetector)this));
            }
            this.previousOpcodeWasNEW = false;
        }
    }

    private boolean isPop(int seen) {
        return seen == 87 || seen == 88;
    }

    static {
        INVOKE_OPCODE_SET.set(185);
        INVOKE_OPCODE_SET.set(183);
        INVOKE_OPCODE_SET.set(184);
        INVOKE_OPCODE_SET.set(182);
    }
}

