/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.db.helpers;

import es.prodevelop.codegen.pui9.model.DatabaseType;
import es.prodevelop.pui9.db.helpers.AbstractDatabaseHelper;
import es.prodevelop.pui9.utils.PuiDateUtil;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.conf.RenderQuotedNames;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;

@Component
public class OracleDatabaseHelper
extends AbstractDatabaseHelper {
    private static final String DATE_TIME_FORMAT = "{DATE_FORMAT} HH24:MI:SS";
    private static final String ORACLE_DATE_TIME_FORMAT = "YYYY-MM-DD\"T\"HH24:MI:SS\"Z\"";
    private static final String ORACLE_DATE_TIME_MILLIS_FORMAT = "YYYY-MM-DD\"T\"HH24:MI:SS.FF3\"Z\"";
    private static final String ACCENTS = "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u0161\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff\u017e";
    private static final String NO_ACCENTS = "aaaaaaceeeeiiiinoooooosuuuuyyz";

    public DatabaseType getDatabaseType() {
        return DatabaseType.ORACLE;
    }

    protected DSLContext initializeDSLContext() {
        return DSL.using((SQLDialect)SQLDialect.DEFAULT, (Settings)new Settings().withRenderFormatted(Boolean.valueOf(true)).withRenderQuotedNames(RenderQuotedNames.NEVER));
    }

    protected String getSqlCastToString() {
        return "TO_CHAR(_columnname_)";
    }

    protected String getSqlConvertDateIntoString(ZoneId zoneId) {
        if (TimeZone.getDefault().equals(TimeZone.getTimeZone(PuiDateUtil.utcZone))) {
            return "TO_CHAR(_columnname_ at time zone '_timezone_', '" + this.adaptDateFormatToUser(DATE_TIME_FORMAT) + "')";
        }
        return "TO_CHAR(CAST(_columnname_ AS timestamp) at time zone '_timezone_', '" + this.adaptDateFormatToUser(DATE_TIME_FORMAT) + "')";
    }

    protected String getSqlConvertStringIntoDate(boolean hasMillis) {
        return "TO_TIMESTAMP('_value_', '" + (hasMillis ? ORACLE_DATE_TIME_MILLIS_FORMAT : ORACLE_DATE_TIME_FORMAT) + "')";
    }

    protected String getSqlTextOperation(boolean caseSensitiveAndAccents, boolean isLargeStringField, boolean dataIsColumn) {
        if (dataIsColumn) {
            return "_columnname__op_'_beginning_' || _value_ || '_end_'";
        }
        if (caseSensitiveAndAccents) {
            if (!isLargeStringField) {
                return "_columnname__op_'_beginning_' || '_value_' || '_end_'";
            }
            return "dbms_lob.compare(_columnname_, '_value_') _op_ 0";
        }
        if (!isLargeStringField) {
            return "TRANSLATE(LOWER(_columnname_), '\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u0161\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff\u017e', 'aaaaaaceeeeiiiinoooooosuuuuyyz')_op_'_beginning_' || TRANSLATE(LOWER('_value_'),'\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u0161\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff\u017e','aaaaaaceeeeiiiinoooooosuuuuyyz') || '_end_'";
        }
        return "LOWER(_columnname_)_op_'_beginning_' || TRANSLATE(LOWER('_value_'),'\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u0161\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff\u017e','aaaaaaceeeeiiiinoooooosuuuuyyz') || '_end_'";
    }

    public <S extends SelectJoinStep<Record>> S getSqlForPagination(int page, int size, S select) {
        int from = page * size + 1;
        int to = from + size - 1;
        Table realSelect = select.asTable("a");
        SelectConditionStep innerSelect = this.getDSLContext().select(new SelectFieldOrAsterisk[]{DSL.field((String)"rownum").as("rnum"), DSL.table((String)"a").asterisk()}).from((TableLike)realSelect).where(DSL.field((String)"rownum").lessOrEqual((Object)DSL.inline((int)to)));
        return (S)((SelectJoinStep)this.getDSLContext().select(new SelectFieldOrAsterisk[]{DSL.asterisk()}).from((TableLike)innerSelect).where(DSL.field((String)"rnum").greaterOrEqual((Object)DSL.inline((int)from))));
    }

    public Select<Record> getViewsSql(Collection<String> viewNames) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(DSL.field((String)"view_name").as("name"));
        fields.add(DSL.field((String)"text").as("definition"));
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        conditions.add(DSL.function((Name)DSL.unquotedName((String)"lower"), Object.class, (Field[])new Field[]{DSL.field((String)"view_name")}).in((Collection)viewNames.stream().map(DSL::inline).collect(Collectors.toList())));
        return this.getDSLContext().select(fields).from(DSL.unquotedName((String[])new String[]{"SYS", "USER_VIEWS"})).where(conditions);
    }
}

