/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets.frametypes;

import org.glassfish.tyrus.websockets.BaseFrameType;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.StrictUtf8;
import org.glassfish.tyrus.websockets.Utf8Utils;
import org.glassfish.tyrus.websockets.WebSocket;

public class TextFrameType
extends BaseFrameType {
    @Override
    public void setPayload(DataFrame frame, byte[] data) {
        frame.setPayload(data);
    }

    @Override
    public byte[] getBytes(DataFrame dataFrame) {
        byte[] bytes = dataFrame.getBytes();
        if (bytes == null) {
            this.setPayload(dataFrame, Utf8Utils.encode(new StrictUtf8(), dataFrame.getTextPayload()));
        }
        return dataFrame.getBytes();
    }

    @Override
    public void respond(WebSocket socket, DataFrame frame) {
        if (frame.isLast()) {
            socket.onMessage(frame.getTextPayload());
        } else {
            socket.onFragment(frame.isLast(), frame.getTextPayload());
        }
    }
}

