/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets;

import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.draft06.Draft06Handler;
import org.glassfish.tyrus.websockets.draft07.Draft07Handler;
import org.glassfish.tyrus.websockets.draft08.Draft08Handler;
import org.glassfish.tyrus.websockets.draft17.Draft17Handler;

public enum Version {
    DRAFT17("13"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft17Handler(mask);
        }

        @Override
        public boolean validate(WebSocketRequest request) {
            return this.wireProtocolVersion.equals(request.getFirstHeaderValue("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT08("8"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft08Handler(mask);
        }

        @Override
        public boolean validate(WebSocketRequest request) {
            return this.wireProtocolVersion.equals(request.getFirstHeaderValue("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT07("7"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft07Handler(mask);
        }

        @Override
        public boolean validate(WebSocketRequest request) {
            return this.wireProtocolVersion.equals(request.getFirstHeaderValue("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT06("6"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new Draft06Handler(mask);
        }

        @Override
        public boolean validate(WebSocketRequest request) {
            return this.wireProtocolVersion.equals(request.getFirstHeaderValue("Sec-WebSocket-Version"));
        }
    };

    protected final String wireProtocolVersion;

    public abstract ProtocolHandler createHandler(boolean var1);

    public abstract boolean validate(WebSocketRequest var1);

    private Version(String wireProtocolVersion) {
        this.wireProtocolVersion = wireProtocolVersion;
    }

    public String toString() {
        return this.name();
    }

    public static String getSupportedWireProtocolVersions() {
        StringBuilder sb = new StringBuilder();
        for (Version v : Version.values()) {
            if (v.wireProtocolVersion.length() <= 0) continue;
            sb.append(v.wireProtocolVersion).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }
}

