/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets;

import java.util.EnumSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.FrameType;
import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketListener;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;
import org.glassfish.tyrus.websockets.frametypes.PingFrameType;
import org.glassfish.tyrus.websockets.frametypes.PongFrameType;

public class DefaultWebSocket
implements WebSocket {
    private final Queue<WebSocketListener> listeners = new ConcurrentLinkedQueue<WebSocketListener>();
    private final ProtocolHandler protocolHandler;
    private final WebSocketRequest request;
    private WebSocketContainer container = null;
    private final CountDownLatch onConnectLatch = new CountDownLatch(1);
    private final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    public DefaultWebSocket(ProtocolHandler protocolHandler, WebSocketRequest request, WebSocketListener ... listeners) {
        this.protocolHandler = protocolHandler;
        this.request = request;
        for (WebSocketListener listener : listeners) {
            this.add(listener);
        }
        protocolHandler.setWebSocket(this);
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public final boolean remove(WebSocketListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void setWriteTimeout(long timeoutMs) {
        this.protocolHandler.setWriteTimeout(timeoutMs);
    }

    @Override
    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    public void setClosed() {
        this.state.set(State.CLOSED);
    }

    @Override
    public void onClose(ClosingFrame frame) {
        WebSocketListener listener;
        while ((listener = this.listeners.poll()) != null) {
            listener.onClose(this, frame);
        }
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(frame.getCode(), frame.getReason());
        } else {
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
        }
    }

    @Override
    public void onConnect() {
        this.state.set(State.CONNECTED);
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
        this.onConnectLatch.countDown();
    }

    @Override
    public void onFragment(boolean last, byte[] fragment) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onFragment(boolean last, String fragment) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onMessage(byte[] data) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, data);
        }
    }

    @Override
    public void onMessage(String text) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, text);
        }
    }

    @Override
    public void onPing(DataFrame frame) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onPing(this, frame.getBytes());
        }
    }

    @Override
    public void onPong(DataFrame frame) {
        this.awaitOnConnect();
        for (WebSocketListener listener : this.listeners) {
            listener.onPong(this, frame.getBytes());
        }
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int code) {
        this.close(code, null);
    }

    @Override
    public void close(int code, String reason) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(code, reason);
        }
    }

    @Override
    public Future<DataFrame> send(byte[] data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> send(String data) {
        if (this.isConnected()) {
            return this.protocolHandler.send(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> sendPing(byte[] data) {
        return this.send(new DataFrame((FrameType)new PingFrameType(), data));
    }

    @Override
    public Future<DataFrame> sendPong(byte[] data) {
        return this.send(new DataFrame((FrameType)new PongFrameType(), data));
    }

    private void awaitOnConnect() {
        try {
            this.onConnectLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Future<DataFrame> send(DataFrame frame) {
        if (this.isConnected()) {
            return this.protocolHandler.send(frame);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> stream(boolean last, String fragment) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, fragment);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> stream(boolean last, byte[] bytes, int off, int len) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(last, bytes, off, len);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

