/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.websocket.Extension;

public class TyrusExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(TyrusExtension.class.getName());
    private final String name;
    private final List<Extension.Parameter> parameters;

    public TyrusExtension(String name) {
        this(name, null);
    }

    public TyrusExtension(String name, List<Extension.Parameter> parameters) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.parameters = parameters != null ? Collections.unmodifiableList(new ArrayList<Extension.Parameter>(parameters)) : Collections.unmodifiableList(Collections.emptyList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Extension.Parameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "TyrusExtension{name='" + this.name + '\'' + ", parameters=" + this.parameters + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TyrusExtension that = (TyrusExtension)o;
        return this.name.equals(that.name) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public static List<Extension> fromString(String s) {
        return TyrusExtension.fromHeaders(Arrays.asList(s));
    }

    public static List<Extension> fromHeaders(List<String> extensionHeaders) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (String singleHeader : extensionHeaders) {
            if (singleHeader == null) break;
            char[] chars = singleHeader.toCharArray();
            int i = 0;
            ParserState next = ParserState.NAME_START;
            StringBuilder name = new StringBuilder();
            StringBuilder paramName = new StringBuilder();
            StringBuilder paramValue = new StringBuilder();
            ArrayList<Extension.Parameter> params = new ArrayList<Extension.Parameter>();
            do {
                block0 : switch (next) {
                    case NAME_START: {
                        if (name.length() > 0) {
                            extensions.add(new TyrusExtension(name.toString().trim(), params));
                            name = new StringBuilder();
                            paramName = new StringBuilder();
                            paramValue = new StringBuilder();
                            params.clear();
                        }
                        next = ParserState.NAME;
                    }
                    case NAME: {
                        switch (chars[i]) {
                            case ';': {
                                next = ParserState.PARAM_NAME;
                                break block0;
                            }
                            case ',': {
                                next = ParserState.NAME_START;
                                break block0;
                            }
                            case '=': {
                                next = ParserState.ERROR;
                                break block0;
                            }
                        }
                        name.append(chars[i]);
                        break;
                    }
                    case PARAM_NAME: {
                        switch (chars[i]) {
                            case ';': {
                                next = ParserState.ERROR;
                                break block0;
                            }
                            case '=': {
                                next = ParserState.PARAM_VALUE;
                                break block0;
                            }
                        }
                        paramName.append(chars[i]);
                        break;
                    }
                    case PARAM_VALUE: {
                        switch (chars[i]) {
                            case '\"': {
                                if (paramValue.length() > 0) {
                                    next = ParserState.ERROR;
                                    break block0;
                                }
                                next = ParserState.PARAM_VALUE_QUOTED;
                                break block0;
                            }
                            case ';': {
                                next = ParserState.PARAM_NAME;
                                params.add(new TyrusParameter(paramName.toString().trim(), paramValue.toString().trim()));
                                paramName = new StringBuilder();
                                paramValue = new StringBuilder();
                                break block0;
                            }
                            case ',': {
                                next = ParserState.NAME_START;
                                params.add(new TyrusParameter(paramName.toString().trim(), paramValue.toString().trim()));
                                paramName = new StringBuilder();
                                paramValue = new StringBuilder();
                                break block0;
                            }
                            case '=': {
                                next = ParserState.ERROR;
                                break block0;
                            }
                        }
                        paramValue.append(chars[i]);
                        break;
                    }
                    case PARAM_VALUE_QUOTED: {
                        switch (chars[i]) {
                            case '\"': {
                                next = ParserState.PARAM_VALUE_QUOTED_POST;
                                params.add(new TyrusParameter(paramName.toString().trim(), paramValue.toString()));
                                paramName = new StringBuilder();
                                paramValue = new StringBuilder();
                                break block0;
                            }
                            case '\\': {
                                next = ParserState.PARAM_VALUE_QUOTED_QP;
                                break block0;
                            }
                            case '=': {
                                next = ParserState.ERROR;
                                break block0;
                            }
                        }
                        paramValue.append(chars[i]);
                        break;
                    }
                    case PARAM_VALUE_QUOTED_QP: {
                        next = ParserState.PARAM_VALUE_QUOTED;
                        paramValue.append(chars[i]);
                        break;
                    }
                    case PARAM_VALUE_QUOTED_POST: {
                        switch (chars[i]) {
                            case ',': {
                                next = ParserState.NAME_START;
                                break block0;
                            }
                            case ';': {
                                next = ParserState.PARAM_NAME;
                                break block0;
                            }
                        }
                        next = ParserState.ERROR;
                        break;
                    }
                    case ERROR: {
                        LOGGER.fine(String.format("Error during parsing Extension: %s", name));
                        if (name.length() > 0) {
                            name = new StringBuilder();
                            paramName = new StringBuilder();
                            paramValue = new StringBuilder();
                            params.clear();
                        }
                        switch (chars[i]) {
                            case ',': {
                                next = ParserState.NAME_START;
                                break block0;
                            }
                            case ';': {
                                next = ParserState.PARAM_NAME;
                            }
                        }
                    }
                }
            } while (++i < chars.length);
            if (name.length() > 0 && next != ParserState.ERROR) {
                if (paramName.length() > 0) {
                    params.add(new TyrusParameter(paramName.toString().trim(), paramValue.toString()));
                }
                extensions.add(new TyrusExtension(name.toString().trim(), params));
                params.clear();
                continue;
            }
            LOGGER.fine(String.format("Unable to parse Extension: %s", name));
        }
        return extensions;
    }

    public static class TyrusParameter
    implements Extension.Parameter {
        private final String name;
        private final String value;

        public TyrusParameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    private static enum ParserState {
        NAME_START,
        NAME,
        PARAM_NAME,
        PARAM_VALUE,
        PARAM_VALUE_QUOTED,
        PARAM_VALUE_QUOTED_POST,
        PARAM_VALUE_QUOTED_QP,
        ERROR;

    }
}

