/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.telenordigital.nbiot.Team;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableTeamList
implements Team.TeamList {
    @Nullable
    private final Team[] teams;

    private ImmutableTeamList(@Nullable Team[] teams) {
        this.teams = teams;
    }

    @Override
    @JsonProperty(value="teams")
    @Nullable
    public Team[] teams() {
        return this.teams;
    }

    public final ImmutableTeamList withTeams(Team ... elements) {
        Team[] newValue = elements == null ? null : (Team[])elements.clone();
        return new ImmutableTeamList(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTeamList && this.equalTo((ImmutableTeamList)another);
    }

    private boolean equalTo(ImmutableTeamList another) {
        return Arrays.equals(this.teams, another.teams);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.teams);
        return h;
    }

    public String toString() {
        return "TeamList{teams=" + Arrays.toString(this.teams) + "}";
    }

    public static ImmutableTeamList copyOf(Team.TeamList instance) {
        if (instance instanceof ImmutableTeamList) {
            return (ImmutableTeamList)instance;
        }
        return new Builder().from(instance).build();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Team[] teams;

        public final Builder from(Team.TeamList instance) {
            Objects.requireNonNull(instance, "instance");
            Team[] teamsValue = instance.teams();
            if (teamsValue != null) {
                this.teams(teamsValue);
            }
            return this;
        }

        @JsonProperty(value="teams")
        public final Builder teams(Team ... teams) {
            this.teams = teams;
            return this;
        }

        public ImmutableTeamList build() {
            return new ImmutableTeamList(this.teams);
        }
    }
}

