/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.telenordigital.nbiot.Collection;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableCollectionList
implements Collection.CollectionList {
    @Nullable
    private final Collection[] collections;

    private ImmutableCollectionList(@Nullable Collection[] collections) {
        this.collections = collections;
    }

    @Override
    @JsonProperty(value="collections")
    @Nullable
    public Collection[] collections() {
        return this.collections;
    }

    public final ImmutableCollectionList withCollections(Collection ... elements) {
        Collection[] newValue = elements == null ? null : (Collection[])elements.clone();
        return new ImmutableCollectionList(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCollectionList && this.equalTo((ImmutableCollectionList)another);
    }

    private boolean equalTo(ImmutableCollectionList another) {
        return Arrays.equals(this.collections, another.collections);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.collections);
        return h;
    }

    public String toString() {
        return "CollectionList{collections=" + Arrays.toString(this.collections) + "}";
    }

    public static ImmutableCollectionList copyOf(Collection.CollectionList instance) {
        if (instance instanceof ImmutableCollectionList) {
            return (ImmutableCollectionList)instance;
        }
        return new Builder().from(instance).build();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Collection[] collections;

        public final Builder from(Collection.CollectionList instance) {
            Objects.requireNonNull(instance, "instance");
            Collection[] collectionsValue = instance.collections();
            if (collectionsValue != null) {
                this.collections(collectionsValue);
            }
            return this;
        }

        @JsonProperty(value="collections")
        public final Builder collections(Collection ... collections) {
            this.collections = collections;
            return this;
        }

        public ImmutableCollectionList build() {
            return new ImmutableCollectionList(this.collections);
        }
    }
}

