/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

class Config {
    public static final String DEFAULT_ENDPOINT = "https://api.nbiot.telenor.io";
    public static final String DEFAULT_TOKEN = "";
    private static final Logger LOG = Logger.getGlobal();
    private String endpoint = "https://api.nbiot.telenor.io";
    private String token = "";

    public Config() {
        String envToken;
        try {
            Path configFile = Paths.get(System.getProperty("user.home"), ".telenor-nbiot");
            if (configFile.toFile().exists()) {
                this.readFile(configFile);
            }
        }
        catch (IOException ioe) {
            LOG.finest("Got exception reading config file. Ignoring it: " + ioe.getMessage());
        }
        String envEndpoint = System.getenv("TELENOR_NBIOT_ADDRESS");
        if (envEndpoint != null && !envEndpoint.isEmpty()) {
            this.endpoint = envEndpoint;
        }
        if ((envToken = System.getenv("TELENOR_NBIOT_TOKEN")) != null && !envToken.isEmpty()) {
            this.token = envToken;
        }
    }

    private void readFile(Path sourcePath) throws IOException {
        Files.lines(sourcePath).forEach(text -> {
            String[] elements = text.split("=");
            if (elements.length < 2) {
                LOG.finest("Ignoring line with " + text);
                return;
            }
            if (elements[0].startsWith("#")) {
                return;
            }
            if (elements[0].startsWith("address")) {
                this.endpoint = elements[1];
                return;
            }
            if (elements[0].startsWith("token")) {
                this.token = elements[1];
                return;
            }
            LOG.fine("Unknown entry in file: " + text);
        });
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String token() {
        return this.token;
    }
}

