/*
 * Decompiled with CFR 0.152.
 */
package dev.syncended.kube.spring.core.controller;

import dev.syncended.kube.core.KubeStyling;
import dev.syncended.kube.core.model.Font;
import dev.syncended.kube.core.model.FontKt;
import dev.syncended.kube.core.model.FontResource;
import dev.syncended.kube.spring.core.utils.FontUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(value={"kube.resources.mode"}, havingValue="LINK", matchIfMissing=true)
@RequestMapping(value={"/${kube.resources.prefix:static}"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0007J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u0005H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Ldev/syncended/kube/spring/core/controller/ResourcesController;", "", "<init>", "()V", "mainCss", "", "getMainCss", "()Ljava/lang/String;", "mainCss$delegate", "Lkotlin/Lazy;", "fonts", "Lorg/springframework/http/ResponseEntity;", "getFont", "", "path", "core"})
@SourceDebugExtension(value={"SMAP\nResourcesController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesController.kt\ndev/syncended/kube/spring/core/controller/ResourcesController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1368#2:54\n1454#2,5:55\n1#3:60\n*S KotlinDebug\n*F\n+ 1 ResourcesController.kt\ndev/syncended/kube/spring/core/controller/ResourcesController\n*L\n40#1:54\n40#1:55,5\n*E\n"})
public final class ResourcesController {
    @NotNull
    private final Lazy mainCss$delegate = LazyKt.lazy(ResourcesController::mainCss_delegate$lambda$0);

    private final String getMainCss() {
        Lazy lazy = this.mainCss$delegate;
        return (String)lazy.getValue();
    }

    @GetMapping(value={"/css/main.css"})
    @NotNull
    public final ResponseEntity<String> fonts() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.valueOf((String)"text/css"));
        return new ResponseEntity((Object)this.getMainCss(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/font/{path}"})
    @NotNull
    public final ResponseEntity<byte[]> getFont(@PathVariable(value="path") @NotNull String path) {
        Object v0;
        block3: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$flatMap$iv = KubeStyling.INSTANCE.getFonts();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Font it = (Font)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getResources();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                FontResource it = (FontResource)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)FontKt.getName((FontResource)it), (Object)path)) continue;
                v0 = e;
                break block3;
            }
            v0 = null;
        }
        FontResource fontResource = v0;
        if (fontResource == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        FontResource font = fontResource;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(FontUtilsKt.getContentType(font));
        byte[] resource = FontKt.getBytes((FontResource)font);
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private static final String mainCss_delegate$lambda$0() {
        return KubeStyling.INSTANCE.buildStyle();
    }
}

