/*
 * Decompiled with CFR 0.152.
 */
package dev.skywolfxp.transcript;

import gg.jte.TemplateOutput;
import gg.jte.html.escape.Escape;
import gg.jte.output.StringOutput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import org.jetbrains.annotations.NotNull;

public class TranscriptUtils {
    private static final Pattern UNDERLINE = Pattern.compile("__(?!_)(.+?)__");
    private static final Pattern BOLD = Pattern.compile("\\*\\*(?!\\*)(.+?)\\*\\*");
    private static final Pattern ITALIC = Pattern.compile("[*_](?![*_])(.+?)[_*]");
    private static final Pattern STRIKE_THROUGH = Pattern.compile("~~(.+?)~~");
    private static final Pattern LINK = Pattern.compile("\\[(.*)]\\((\\S*)\\)");
    private static final Pattern CODE_BLOCK = Pattern.compile("```\\n(.*)\\n```", 32);
    private static final Pattern CODE_INLINE = Pattern.compile("`(?!`)(.*)`");
    private static final Pattern HEADER_1 = Pattern.compile("^#\\s(.*)(?=<br>)|^#\\s(.*)", 8);
    private static final Pattern HEADER_2 = Pattern.compile("^##\\s(.*)(?=<br>)|^##\\s(.*)", 8);
    private static final Pattern HEADER_3 = Pattern.compile("^###\\s(.*)(?=<br>)|^###\\s(.*)", 8);
    private static final Pattern SUBTEXT = Pattern.compile("^-# (.*)$", 8);
    private static final Pattern MENTION_USER = Pattern.compile("&lt;@(\\d+)&gt;");
    private static final Pattern MENTION_ROLE = Pattern.compile("&lt;@&amp;(\\d+)&gt;");
    private static final Pattern MENTION_CHANNEL = Pattern.compile("&lt;#(\\d+)&gt;");
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;

    @NotNull
    public static String parseMarkup(Guild guild, @NotNull String message) {
        String escapedMessage = TranscriptUtils.escapeMessage(message).replaceAll("(?<!```)\\n", "<br>\n");
        Matcher matcher = UNDERLINE.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<u>%s</u>".formatted(matcher.group(1)));
        }
        matcher = BOLD.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<strong>%s</strong>".formatted(matcher.group(1)));
        }
        matcher = ITALIC.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<em>%s</em>".formatted(matcher.group(1)));
        }
        matcher = STRIKE_THROUGH.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<s>%s</s>".formatted(matcher.group(1)));
        }
        matcher = LINK.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<a href=\"%s\" class=\"markup__link\">%s</a>".formatted(matcher.group(2), matcher.group(1)));
        }
        matcher = HEADER_1.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<h1 class=\"markup__header\">%s</h1>".formatted(matcher.group(1)));
        }
        matcher = HEADER_2.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<h2 class=\"markup__header\">%s</h2>".formatted(matcher.group(1)));
        }
        matcher = HEADER_3.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<h3 class=\"markup__header\">%s</h3>".formatted(matcher.group(1)));
        }
        matcher = SUBTEXT.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<small class=\"markup__subtext\">%s</small>".formatted(matcher.group(1)));
        }
        matcher = CODE_BLOCK.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<code class=\"markup__code-block\">%s</code>".formatted(matcher.group(1)));
        }
        matcher = CODE_INLINE.matcher(escapedMessage);
        while (matcher.find()) {
            escapedMessage = escapedMessage.replace(matcher.group(), "<code class=\"markup__code-inline\">%s</code>".formatted(matcher.group(1)));
        }
        matcher = MENTION_USER.matcher(escapedMessage);
        while (matcher.find()) {
            String userId = matcher.group(1);
            User user = guild.getJDA().getUserById(userId);
            if (user == null) {
                escapedMessage = escapedMessage.replace(matcher.group(), "<span class=\"mention\">\n  <@%s>\n</span>\n".formatted(userId));
                continue;
            }
            escapedMessage = escapedMessage.replace(matcher.group(), "<a href=\"https://discord.com/users/%s\" class=\"mention\">\n  @%s\n</a>\n".formatted(userId, user.getEffectiveName()));
        }
        matcher = MENTION_ROLE.matcher(escapedMessage);
        while (matcher.find()) {
            String roleId = matcher.group(1);
            Role role = guild.getRoleById(roleId);
            if (role == null) {
                escapedMessage = escapedMessage.replace(matcher.group(), "<span class=\"mention\">\n  @unknown-role\n</span>\n");
                continue;
            }
            escapedMessage = escapedMessage.replace(matcher.group(), "<span class=\"mention\" style=\"color: #%1$06X; background-color: #%1$06X10;\" onmouseover=\"this.style.backgroundColor='#%1$06X30';\" onmouseout=\"this.style.backgroundColor='#%1$06X10';\">@%2$s</span>\n".formatted(role.getColorRaw(), role.getName()));
        }
        matcher = MENTION_CHANNEL.matcher(escapedMessage);
        while (matcher.find()) {
            String channelId = matcher.group(1);
            GuildChannel channel = guild.getGuildChannelById(channelId);
            if (channel == null) {
                escapedMessage = escapedMessage.replace(matcher.group(), "<span class=\"mention\">\n  <svg\n    xmlns=\"http://www.w3.org/2000/svg\"\n    viewBox=\"0 0 24 24\"\n    fill=\"currentColor\"\n    class=\"mention__channel-icon\"\n  >\n    <path\n      fill-rule=\"evenodd\"\n      d=\"M10.99 3.16A1 1 0 1 0 9 2.84L8.15 8H4a1 1 0 0 0 0 2h3.82l-.67 4H3a1 1 0 1 0 0 2h3.82l-.8 4.84a1 1 0 0 0 1.97.32L8.85 16h4.97l-.8 4.84a1 1 0 0 0 1.97.32l.86-5.16H20a1 1 0 1 0 0-2h-3.82l.67-4H21a1 1 0 1 0 0-2h-3.82l.8-4.84a1 1 0 1 0-1.97-.32L15.15 8h-4.97l.8-4.84ZM14.15 14l.67-4H9.85l-.67 4h4.97Z\"\n    />\n  </svg>\n\n  <em>unknown</em>\n</span>\n");
                continue;
            }
            escapedMessage = escapedMessage.replace(matcher.group(), "<a href=\"https://discord.com/channels/%s/%s\" class=\"mention\">\n  <svg\n    xmlns=\"http://www.w3.org/2000/svg\"\n    viewBox=\"0 0 24 24\"\n    fill=\"currentColor\"\n    class=\"mention__channel-icon\"\n  >\n    <path\n      fill-rule=\"evenodd\"\n      d=\"M10.99 3.16A1 1 0 1 0 9 2.84L8.15 8H4a1 1 0 0 0 0 2h3.82l-.67 4H3a1 1 0 1 0 0 2h3.82l-.8 4.84a1 1 0 0 0 1.97.32L8.85 16h4.97l-.8 4.84a1 1 0 0 0 1.97.32l.86-5.16H20a1 1 0 1 0 0-2h-3.82l.67-4H21a1 1 0 1 0 0-2h-3.82l.8-4.84a1 1 0 1 0-1.97-.32L15.15 8h-4.97l.8-4.84ZM14.15 14l.67-4H9.85l-.67 4h4.97Z\"\n    />\n  </svg>\n\n  <span class=\"mention__channel-name\">%s</span>\n</a>\n".formatted(guild.getId(), channelId, channel.getName()));
        }
        return escapedMessage;
    }

    @NotNull
    public static String formatBytes(int bytes) {
        if ((long)bytes < 1024L) {
            return "%s bytes".formatted(bytes);
        }
        if ((long)bytes < 0x100000L) {
            return "%.2f KB".formatted((double)bytes / 1024.0);
        }
        if ((long)bytes < 0x40000000L) {
            return "%.2f MB".formatted((double)bytes / 1048576.0);
        }
        return "%.2f GB".formatted((double)bytes / 1.073741824E9);
    }

    @NotNull
    private static String escapeMessage(@NotNull String messageContent) {
        StringOutput stringOutput = new StringOutput();
        Escape.htmlContent((String)messageContent, (TemplateOutput)stringOutput);
        return stringOutput.toString();
    }
}

