/*
 * Decompiled with CFR 0.152.
 */
package dev.skywolfxp.transcript;

import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateException;
import gg.jte.TemplateOutput;
import gg.jte.output.Utf8ByteOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.utils.FileUpload;
import org.jetbrains.annotations.NotNull;

public final class Transcript {
    private final TemplateEngine templateEngine = TemplateEngine.createPrecompiled((ContentType)ContentType.Html);
    private final Utf8ByteOutput utf8ByteOutput = new Utf8ByteOutput();
    private final HashMap<String, Object> params = new HashMap();

    public void render(@NotNull TextChannel textChannel) throws IllegalArgumentException, TemplateException {
        List<Message> messages = textChannel.getIterableHistory().stream().sorted(Comparator.comparing(ISnowflake::getTimeCreated)).toList();
        if (messages.isEmpty()) {
            throw new IllegalArgumentException("TextChannel '%s' contains no messages".formatted(textChannel.getName()));
        }
        this.params.put("textChannel", textChannel);
        this.params.put("messages", messages);
        this.params.put("isDev", false);
        this.templateEngine.render("template.jte", this.params, (TemplateOutput)this.utf8ByteOutput);
    }

    @NotNull
    public FileUpload toFileUpload(@NotNull String fileName) {
        return FileUpload.fromData((byte[])this.utf8ByteOutput.toByteArray(), (String)(fileName.endsWith(".html") ? fileName : fileName + ".html"));
    }

    public void writeToFile(@NotNull File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(this.utf8ByteOutput.toByteArray());
        }
    }
}

