/*
 * Decompiled with CFR 0.152.
 */
package dev.skywolfxp.transcript;

import dev.skywolfxp.transcript.Transcript;
import gg.jte.TemplateOutput;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import org.jetbrains.annotations.NotNull;

public final class TranscriptGenerator {
    private final Transcript transcript;

    public TranscriptGenerator(@NotNull Transcript transcript) {
        this.transcript = transcript;
    }

    @NotNull
    public Transcript createTranscript(@NotNull TextChannel textChannel) throws IllegalArgumentException {
        List<Message> messages = textChannel.getIterableHistory().stream().sorted(Comparator.comparing(ISnowflake::getTimeCreated)).toList();
        if (messages.isEmpty()) {
            throw new IllegalArgumentException("TextChannel: %s contains no messages".formatted(textChannel.getName()));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("textChannel", textChannel);
        params.put("messages", messages);
        params.put("isDev", false);
        this.transcript.getTemplateEngine().render("template.jte", params, (TemplateOutput)this.transcript.getUtf8ByteOutput());
        return this.transcript;
    }
}

