/*
 * Decompiled with CFR 0.152.
 */
package dev.skywolfxp.transcript;

import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.output.Utf8ByteOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.dv8tion.jda.api.utils.FileUpload;
import org.jetbrains.annotations.NotNull;

public final class Transcript {
    private final TemplateEngine templateEngine;
    private final Utf8ByteOutput utf8ByteOutput;

    public Transcript() {
        this.templateEngine = TemplateEngine.createPrecompiled((ContentType)ContentType.Html);
        this.utf8ByteOutput = new Utf8ByteOutput();
        this.templateEngine.setBinaryStaticContent(true);
        this.templateEngine.setTrimControlStructures(true);
    }

    public Transcript(@NotNull TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        this.utf8ByteOutput = new Utf8ByteOutput();
    }

    @NotNull
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @NotNull
    public Utf8ByteOutput getUtf8ByteOutput() {
        return this.utf8ByteOutput;
    }

    @NotNull
    public FileUpload toFileUpload(@NotNull String fileName) {
        return FileUpload.fromData((byte[])this.utf8ByteOutput.toByteArray(), (String)(fileName.endsWith(".html") ? fileName : fileName + ".html"));
    }

    public void toFile(@NotNull File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(this.utf8ByteOutput.toByteArray());
        }
    }
}

