/*
 * Decompiled with CFR 0.152.
 */
package dev.inspector.spring.interceptors.rest;

import dev.inspector.agent.executor.Inspector;
import dev.inspector.agent.model.Segment;
import dev.inspector.spring.interceptors.context.InspectorMonitoringContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class RestTemplateMonitoringInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTemplateMonitoringInterceptor.class);
    @Autowired
    private InspectorMonitoringContext inspectorMonitoringContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        LOGGER.debug("Thread {}: Outgoing HTTP call from RestTemplate client intercepted. Starting monitoring segment", (Object)Thread.currentThread().getName());
        Inspector inspector = this.inspectorMonitoringContext.getInspectorService();
        Segment segment = inspector.startSegment("http", request.getURI().toString());
        try {
            ClientHttpResponse clientHttpResponse = execution.execute(request, body);
            return clientHttpResponse;
        }
        finally {
            segment.end();
        }
    }
}

