/*
 * Decompiled with CFR 0.152.
 */
package dev.inspector.spring.interceptors.error;

import dev.inspector.agent.executor.Inspector;
import dev.inspector.agent.model.Transaction;
import dev.inspector.spring.interceptors.context.InspectorMonitoringContext;
import jakarta.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class GlobalExceptionHandler {
    @Autowired
    private InspectorMonitoringContext inspectorMonitoringContext;

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> handleException(Exception ex, HttpServletRequest request) {
        Inspector inspector = this.inspectorMonitoringContext.getInspectorService();
        inspector.reportException((Throwable)ex);
        inspector.getTransaction().setResult("error");
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<String> handleNotFoundException(NoHandlerFoundException ex, HttpServletRequest request) {
        String methodName = request.getMethod() + " " + request.getRequestURI();
        Inspector inspector = this.inspectorMonitoringContext.getInspectorService();
        Transaction transaction = inspector.startTransaction("Error Transaction for " + methodName);
        JSONObject errorContext = new JSONObject();
        errorContext.put("message", (Object)"Resource not found");
        errorContext.put("exception", (Object)ex.getClass().getSimpleName());
        transaction.addContext("Error", errorContext);
        inspector.flush();
        this.inspectorMonitoringContext.removeInspectorService();
        return new ResponseEntity((Object)"Resource not found", (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

