/*
 * Decompiled with CFR 0.152.
 */
package dev.inspector.spring.interceptors.context;

import dev.inspector.agent.executor.Inspector;
import dev.inspector.agent.model.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InspectorMonitoringContext {
    private Config inspectorConfig;
    private ThreadLocal<Inspector> inspectorServiceThreadSafeWrapper;

    public InspectorMonitoringContext(@Autowired Config inspectorConfig) {
        this.inspectorConfig = inspectorConfig;
        this.inspectorServiceThreadSafeWrapper = new ThreadLocal();
    }

    public Inspector getInspectorService() {
        Inspector inspectorService = this.inspectorServiceThreadSafeWrapper.get();
        if (inspectorService == null) {
            inspectorService = new Inspector(this.inspectorConfig);
            this.inspectorServiceThreadSafeWrapper.set(inspectorService);
        }
        return inspectorService;
    }

    public void removeInspectorService() {
        this.inspectorServiceThreadSafeWrapper.remove();
    }
}

