/*
 * Decompiled with CFR 0.152.
 */
package dev.inspector.spring.utils.http.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedBodyServletInputStream
extends ServletInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedBodyServletInputStream.class);
    private final InputStream cachedBodyInputStream;

    public CachedBodyServletInputStream(byte[] cacheBody) {
        this.cachedBodyInputStream = new ByteArrayInputStream(cacheBody);
    }

    public int read() throws IOException {
        return this.cachedBodyInputStream.read();
    }

    public boolean isFinished() {
        try {
            return this.cachedBodyInputStream.available() == 0;
        }
        catch (IOException e) {
            LOGGER.error("Exception occured during checking if input stream is finished", (Throwable)e);
            return false;
        }
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener listener) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

