/*
 * Decompiled with CFR 0.152.
 */
package dev.inspector.spring.interceptors.rest;

import dev.inspector.agent.executor.Inspector;
import dev.inspector.agent.model.Transaction;
import dev.inspector.agent.model.TransactionType;
import dev.inspector.spring.interceptors.context.InspectorMonitoringContext;
import dev.inspector.spring.utils.http.request.CachedBodyHttpServletRequest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class RestInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestInterceptor.class);
    @Autowired
    private InspectorMonitoringContext inspectorMonitoringContext;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        CachedBodyHttpServletRequest cachedHttpRequest = new CachedBodyHttpServletRequest(request);
        String pattern = (String)cachedHttpRequest.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        Inspector inspector = this.inspectorMonitoringContext.getInspectorService();
        Transaction transaction = inspector.startTransaction(String.format("%s %s", cachedHttpRequest.getMethod(), pattern)).withType(TransactionType.REQUEST);
        LOGGER.debug("Thread {}: Incoming http request intercepted. Starting monitoring transaction with hash {} ", (Object)Thread.currentThread().getName(), (Object)transaction.getBasicTransactionInfo().getHash());
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("method", (Object)cachedHttpRequest.getMethod());
        jsonRequest.put("version", (Object)cachedHttpRequest.getProtocol());
        JSONObject socketDetails = new JSONObject();
        socketDetails.put("remote_address", (Object)cachedHttpRequest.getRemoteAddr());
        socketDetails.put("encrypted", cachedHttpRequest.isSecure());
        jsonRequest.put("socket", (Object)socketDetails);
        JSONObject cookies = new JSONObject();
        if (cachedHttpRequest.getCookies() != null) {
            for (Cookie cookie : cachedHttpRequest.getCookies()) {
                cookies.put(cookie.getName(), (Object)cookie.getValue());
            }
        }
        jsonRequest.put("cookies", (Object)cookies);
        JSONObject headers = new JSONObject();
        Enumeration headerNames = cachedHttpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, (Object)cachedHttpRequest.getHeader(headerName));
        }
        jsonRequest.put("headers", (Object)headers);
        String body = cachedHttpRequest.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        jsonRequest.put("body", (Object)body);
        transaction.addContext("Request", jsonRequest);
        JSONObject jsonUrl = new JSONObject();
        jsonUrl.put("protocol", (Object)cachedHttpRequest.getScheme());
        jsonUrl.put("port", cachedHttpRequest.getServerPort());
        jsonUrl.put("path", (Object)cachedHttpRequest.getRequestURI());
        jsonUrl.put("search", (Object)cachedHttpRequest.getQueryString());
        jsonUrl.put("full", (Object)(cachedHttpRequest.getRequestURL().toString() + (cachedHttpRequest.getQueryString() != null ? "?" + cachedHttpRequest.getQueryString() : "")));
        transaction.addContext("URL", jsonUrl);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Inspector inspector = this.inspectorMonitoringContext.getInspectorService();
        Transaction transaction = inspector.getTransaction();
        transaction.setResult(String.valueOf(response.getStatus()));
        LOGGER.debug("Thread {}: Incoming http request response interceptor. Flushing monitoring transaction with hash {} ", (Object)Thread.currentThread().getName(), (Object)transaction.getBasicTransactionInfo().getHash());
        inspector.flush();
        this.inspectorMonitoringContext.removeInspectorService();
    }
}

