/*
 * Decompiled with CFR 0.152.
 */
package dev.inspector.spring.interceptors.rest;

import dev.inspector.agent.executor.Inspector;
import dev.inspector.agent.model.Transaction;
import java.io.IOException;
import java.util.Enumeration;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class RestInterceptor
implements HandlerInterceptor {
    @Autowired
    Inspector inspector;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        String pattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        Transaction transaction = this.inspector.startTransaction(String.format("%s - %s", request.getMethod(), pattern));
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("method", (Object)request.getMethod());
        jsonRequest.put("version", (Object)request.getProtocol());
        JSONObject socketDetails = new JSONObject();
        socketDetails.put("remote_address", (Object)request.getRemoteAddr());
        socketDetails.put("encrypted", request.isSecure());
        jsonRequest.put("socket", (Object)socketDetails);
        JSONObject cookies = new JSONObject();
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                cookies.put(cookie.getName(), (Object)cookie.getValue());
            }
        }
        jsonRequest.put("cookies", (Object)cookies);
        JSONObject headers = new JSONObject();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, (Object)request.getHeader(headerName));
        }
        jsonRequest.put("headers", (Object)headers);
        String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        jsonRequest.put("body", (Object)body);
        transaction.addContext("Request", jsonRequest);
        JSONObject jsonUrl = new JSONObject();
        jsonUrl.put("protocol", (Object)request.getScheme());
        jsonUrl.put("port", request.getServerPort());
        jsonUrl.put("path", (Object)request.getRequestURI());
        jsonUrl.put("search", (Object)request.getQueryString());
        jsonUrl.put("full", (Object)(request.getRequestURL().toString() + (request.getQueryString() != null ? "?" + request.getQueryString() : "")));
        transaction.addContext("URL", jsonUrl);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.inspector.flush();
    }
}

