package io.k8s.api.scheduling.v1

import dev.hnaderi.k8s.client._

/** Pointer for PriorityClass */
final case class PriorityClassPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.scheduling.v1.PriorityClass] {
  def value : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"value")
  def description : Pointer.Plain[String] = Pointer.Plain(currentPath / s"description")
  def globalDefault : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"globalDefault")
  def preemptionPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"preemptionPolicy")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


