package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.client._

/** Pointer for ResourceClass */
final case class ResourceClassPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.resource.v1alpha2.ResourceClass] {
  def driverName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"driverName")
  def suitableNodes :  io.k8s.api.core.v1.NodeSelectorPointer = io.k8s.api.core.v1.NodeSelectorPointer(currentPath / s"suitableNodes")
  def parametersRef :  io.k8s.api.resource.v1alpha2.ResourceClassParametersReferencePointer = io.k8s.api.resource.v1alpha2.ResourceClassParametersReferencePointer(currentPath / s"parametersRef")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


