package io.k8s.api.networking.v1

import dev.hnaderi.k8s.client._

/** Pointer for IngressSpec */
final case class IngressSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.networking.v1.IngressSpec] {
  def defaultBackend :  io.k8s.api.networking.v1.IngressBackendPointer = io.k8s.api.networking.v1.IngressBackendPointer(currentPath / s"defaultBackend")
  def ingressClassName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"ingressClassName")
  def rules : ListPointer[io.k8s.api.networking.v1.IngressRule] = ListPointer(currentPath / s"rules")
  def tls : ListPointer[io.k8s.api.networking.v1.IngressTLS] = ListPointer(currentPath / s"tls")
}


