package io.k8s.api.networking.v1

import dev.hnaderi.k8s.client._

/** Pointer for HTTPIngressPath */
final case class HTTPIngressPathPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.networking.v1.HTTPIngressPath] {
  def backend :  io.k8s.api.networking.v1.IngressBackendPointer = io.k8s.api.networking.v1.IngressBackendPointer(currentPath / s"backend")
  def pathType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"pathType")
  def path : Pointer.Plain[String] = Pointer.Plain(currentPath / s"path")
}


