package io.k8s.api.flowcontrol.v1beta3

import dev.hnaderi.k8s.client._

/** Pointer for LimitedPriorityLevelConfiguration */
final case class LimitedPriorityLevelConfigurationPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.flowcontrol.v1beta3.LimitedPriorityLevelConfiguration] {
  def borrowingLimitPercent : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"borrowingLimitPercent")
  def lendablePercent : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"lendablePercent")
  def limitResponse :  io.k8s.api.flowcontrol.v1beta3.LimitResponsePointer = io.k8s.api.flowcontrol.v1beta3.LimitResponsePointer(currentPath / s"limitResponse")
  def nominalConcurrencyShares : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"nominalConcurrencyShares")
}


