package io.k8s.api.flowcontrol.v1

import dev.hnaderi.k8s.client._

/** Pointer for Subject */
final case class SubjectPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.flowcontrol.v1.Subject] {
  def kind : Pointer.Plain[String] = Pointer.Plain(currentPath / s"kind")
  def group :  io.k8s.api.flowcontrol.v1.GroupSubjectPointer = io.k8s.api.flowcontrol.v1.GroupSubjectPointer(currentPath / s"group")
  def serviceAccount :  io.k8s.api.flowcontrol.v1.ServiceAccountSubjectPointer = io.k8s.api.flowcontrol.v1.ServiceAccountSubjectPointer(currentPath / s"serviceAccount")
  def user :  io.k8s.api.flowcontrol.v1.UserSubjectPointer = io.k8s.api.flowcontrol.v1.UserSubjectPointer(currentPath / s"user")
}


