package io.k8s.api.events.v1

import dev.hnaderi.k8s.client._

/** Pointer for Event */
final case class EventPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.events.v1.Event] {
  def eventTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = Pointer.Plain(currentPath / s"eventTime")
  def regarding :  io.k8s.api.core.v1.ObjectReferencePointer = io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"regarding")
  def series :  io.k8s.api.events.v1.EventSeriesPointer = io.k8s.api.events.v1.EventSeriesPointer(currentPath / s"series")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def deprecatedCount : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"deprecatedCount")
  def related :  io.k8s.api.core.v1.ObjectReferencePointer = io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"related")
  def deprecatedFirstTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"deprecatedFirstTimestamp")
  def note : Pointer.Plain[String] = Pointer.Plain(currentPath / s"note")
  def reportingController : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reportingController")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
  def deprecatedSource :  io.k8s.api.core.v1.EventSourcePointer = io.k8s.api.core.v1.EventSourcePointer(currentPath / s"deprecatedSource")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def deprecatedLastTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"deprecatedLastTimestamp")
  def reportingInstance : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reportingInstance")
  def action : Pointer.Plain[String] = Pointer.Plain(currentPath / s"action")
}


