package io.k8s.api.discovery.v1

import dev.hnaderi.k8s.client._

/** Pointer for Endpoint */
final case class EndpointPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.discovery.v1.Endpoint] {
  def addresses : ListPointer[String] = ListPointer(currentPath / s"addresses")
  def conditions :  io.k8s.api.discovery.v1.EndpointConditionsPointer = io.k8s.api.discovery.v1.EndpointConditionsPointer(currentPath / s"conditions")
  def targetRef :  io.k8s.api.core.v1.ObjectReferencePointer = io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"targetRef")
  def hostname : Pointer.Plain[String] = Pointer.Plain(currentPath / s"hostname")
  def nodeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"nodeName")
  def hints :  io.k8s.api.discovery.v1.EndpointHintsPointer = io.k8s.api.discovery.v1.EndpointHintsPointer(currentPath / s"hints")
  def deprecatedTopology : MapPointer[String] = MapPointer(currentPath / s"deprecatedTopology")
  def zone : Pointer.Plain[String] = Pointer.Plain(currentPath / s"zone")
}


