package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for ResourceFieldSelector */
final case class ResourceFieldSelectorPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ResourceFieldSelector] {
  def resource : Pointer.Plain[String] = Pointer.Plain(currentPath / s"resource")
  def containerName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"containerName")
  def divisor : Pointer.Plain[io.k8s.apimachinery.pkg.api.resource.Quantity] = Pointer.Plain(currentPath / s"divisor")
}


