package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for Pod */
final case class PodPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.Pod] {
  def status :  io.k8s.api.core.v1.PodStatusPointer = io.k8s.api.core.v1.PodStatusPointer(currentPath / s"status")
  def spec :  io.k8s.api.core.v1.PodSpecPointer = io.k8s.api.core.v1.PodSpecPointer(currentPath / s"spec")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


