package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for PersistentVolumeClaimStatus */
final case class PersistentVolumeClaimStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PersistentVolumeClaimStatus] {
  def conditions : ListPointer[io.k8s.api.core.v1.PersistentVolumeClaimCondition] = ListPointer(currentPath / s"conditions")
  def accessModes : ListPointer[String] = ListPointer(currentPath / s"accessModes")
  def currentVolumeAttributesClassName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"currentVolumeAttributesClassName")
  def phase : Pointer.Plain[String] = Pointer.Plain(currentPath / s"phase")
  def modifyVolumeStatus :  io.k8s.api.core.v1.ModifyVolumeStatusPointer = io.k8s.api.core.v1.ModifyVolumeStatusPointer(currentPath / s"modifyVolumeStatus")
  def allocatedResourceStatuses : MapPointer[String] = MapPointer(currentPath / s"allocatedResourceStatuses")
  def allocatedResources : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"allocatedResources")
  def capacity : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"capacity")
}


