package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for LifecycleHandler */
final case class LifecycleHandlerPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.LifecycleHandler] {
  def exec :  io.k8s.api.core.v1.ExecActionPointer = io.k8s.api.core.v1.ExecActionPointer(currentPath / s"exec")
  def httpGet :  io.k8s.api.core.v1.HTTPGetActionPointer = io.k8s.api.core.v1.HTTPGetActionPointer(currentPath / s"httpGet")
  def sleep :  io.k8s.api.core.v1.SleepActionPointer = io.k8s.api.core.v1.SleepActionPointer(currentPath / s"sleep")
  def tcpSocket :  io.k8s.api.core.v1.TCPSocketActionPointer = io.k8s.api.core.v1.TCPSocketActionPointer(currentPath / s"tcpSocket")
}


