package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for ConfigMapNodeConfigSource */
final case class ConfigMapNodeConfigSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ConfigMapNodeConfigSource] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def kubeletConfigKey : Pointer.Plain[String] = Pointer.Plain(currentPath / s"kubeletConfigKey")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
  def resourceVersion : Pointer.Plain[String] = Pointer.Plain(currentPath / s"resourceVersion")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
}


