package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for CinderVolumeSource */
final case class CinderVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.CinderVolumeSource] {
  def volumeID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeID")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def secretRef :  io.k8s.api.core.v1.LocalObjectReferencePointer = io.k8s.api.core.v1.LocalObjectReferencePointer(currentPath / s"secretRef")
}


